package org.jamon.node;

import org.jamon.api.Location;
public class GenericsBoundNode extends AbstractNode {
  public GenericsBoundNode(Location location, String className) {
    super(location);
    if ((this.className = className) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseGenericsBoundNode(this);
  }

  private final String className;
  public String getClassName() { return className; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && className.equals(((GenericsBoundNode) obj).className)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ className.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "className", className);
  }

}
