package org.jamon.node;

import org.jamon.api.Location;
public class IfNode extends AbstractBodyNode {
  public IfNode(Location location, String condition) {
    super(location);
    if ((this.condition = condition) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseIfNode(this);
  }

  private final String condition;
  public String getCondition() { return condition; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && condition.equals(((IfNode) obj).condition)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ condition.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "condition", condition);
  }

}
