package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class MultiFragmentCallNode extends AbstractComponentCallNode {
  public MultiFragmentCallNode(Location location, AbstractPathNode callPath, AbstractParamsNode params) {
    super(location, callPath, params);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseMultiFragmentCallNode(this);
  }

  private final List<NamedFragmentNode> fragments = new ArrayList<NamedFragmentNode>();
  public MultiFragmentCallNode addFragment(NamedFragmentNode fragment) {
    if (fragment == null) { throw new NullPointerException(); }
    fragments.add(fragment);
    return this;
  }
  public List<NamedFragmentNode> getFragments() { return fragments; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && fragments.equals(((MultiFragmentCallNode) obj).fragments)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ fragments.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "fragment", fragments);
  }

}
