package org.jamon.node;

import org.jamon.api.Location;
public class NamedAliasPathNode extends AbstractPathNode {
  public NamedAliasPathNode(Location location, String alias) {
    super(location);
    if ((this.alias = alias) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseNamedAliasPathNode(this);
  }

  private final String alias;
  public String getAlias() { return alias; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && alias.equals(((NamedAliasPathNode) obj).alias)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ alias.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "alias", alias);
  }

}
