package org.jamon.node;

import org.jamon.api.Location;
public class ParamValueNode extends AbstractNode {
  public ParamValueNode(Location location, String value) {
    super(location);
    if ((this.value = value) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseParamValueNode(this);
  }

  private final String value;
  public String getValue() { return value; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && value.equals(((ParamValueNode) obj).value)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ value.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "value", value);
  }

}
