package org.jamon.node;

import org.jamon.api.Location;
public class ParentArgWithDefaultNode extends ParentArgNode {
  public ParentArgWithDefaultNode(Location location, ArgNameNode name, ArgValueNode value) {
    super(location, name);
    if ((this.value = value) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseParentArgWithDefaultNode(this);
  }

  private final ArgValueNode value;
  public ArgValueNode getValue() { return value; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && value.equals(((ParentArgWithDefaultNode) obj).value)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ value.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "value", value);
  }

}
