package org.jamon.node;

import org.jamon.api.Location;
public class ReplacesNode extends AbstractNode {
  public ReplacesNode(Location location, AbstractPathNode path) {
    super(location);
    if ((this.path = path) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseReplacesNode(this);
  }

  private final AbstractPathNode path;
  public AbstractPathNode getPath() { return path; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && path.equals(((ReplacesNode) obj).path)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ path.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "path", path);
  }

}
