/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Jamon code, released February, 2003.
 *
 * The Initial Developer of the Original Code is Jay Sachs.  Portions
 * created by Jay Sachs are Copyright (C) 2003 Jay Sachs.  All Rights
 * Reserved.
 *
 * Contributor(s):
 */

package org.jamon;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

/**
 * A simple abstract class which lacks only a Writer to which to render.
 */
public abstract class AbstractRenderer
    implements Renderer
{
    /**
     * Render to the given writer.
     *
     * @param p_writer the Writer to which to render
     *
     * @exception IOException if writing to the Writer throws an IOException
     */
    @Override
    public abstract void renderTo(Writer p_writer)
        throws IOException;


    /**
     * Render this Renderer into a String.
     *
     * @return a String that is the result of rendering this Renderer
     */
    @Override
    public final String asString()
    {
        StringWriter writer = new StringWriter();
        try
        {
            renderTo(writer);
        }
        catch (IOException e)
        {
            // It's a StringWriter, so we shouldn't ever get here
            throw new RuntimeException(e);
        }
        return writer.toString();
    }
}
