/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Jamon code, released February, 2011.
 *
 * The Initial Developer of the Original Code is Ian Robertson.  Portions
 * created by Ian Robertson are Copyright (C) 2011 Ian Robertson.  All Rights
 * Reserved.
 *
 * Contributor(s):
 */

package org.jamon;

import org.jamon.AbstractTemplateProxy.Intf;

/**
 * An abstract implementation of {@code TemplateManager} which handles some of the common tasks
 * surrounding template replacement.
 */
public abstract class AbstractTemplateManager implements TemplateManager
{
    private final TemplateReplacer m_templateReplacer;

    protected AbstractTemplateManager() {
        m_templateReplacer = IdentityTemplateReplacer.INSTANCE;
    }

    protected AbstractTemplateManager(TemplateReplacer p_templateReplacer) {
        m_templateReplacer = p_templateReplacer;
    }

    protected TemplateReplacer getTemplateReplacer() {
      return m_templateReplacer;
    }

    /**
     * {@inheritDoc}
     * This implementation simply calls
     * {@link #constructImpl(AbstractTemplateProxy, Object) constructImpl(p_proxy, null)}.
     **/
    @Override
    public Intf constructImpl(AbstractTemplateProxy p_proxy)
    {
        return constructImpl(p_proxy, null);
    }

    /**
     * {@inheritDoc}
     * This implementation simply calls
     * <code>
     * <pre>
     *   constructImplFromReplacedProxy(
     *     getTemplateReplacer().getReplacement(p_proxy, p_jamonContext))
     * </pre>
     **/
    @Override
    public Intf constructImpl(AbstractTemplateProxy p_proxy, Object p_jamonContext)
    {
        return constructImplFromReplacedProxy(
            getTemplateReplacer().getReplacement(p_proxy, p_jamonContext));
    }

    protected abstract Intf constructImplFromReplacedProxy(AbstractTemplateProxy p_replacedProxy);
}
