/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.example;

import java.io.IOException;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.example.GraphApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusGraphApp
extends GraphApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(JanusGraphApp.class);
    protected static final String APP_NAME = "jgex";
    protected static final String MIXED_INDEX_CONFIG_NAME = "jgex";
    protected static final String BERKELEYJE = "berkeleyje";
    protected static final String CASSANDRA = "cassandra";
    protected static final String CQL = "cql";
    protected static final String HBASE = "hbase";
    protected static final String INMEMORY = "inmemory";
    protected static final String LUCENE = "lucene";
    protected static final String ELASTICSEARCH = "elasticsearch";
    protected static final String SOLR = "solr";
    protected boolean useMixedIndex;
    protected String mixedIndexConfigName;

    public JanusGraphApp(String fileName) {
        super(fileName);
        this.supportsSchema = true;
        this.supportsTransactions = true;
        this.supportsGeoshape = true;
        this.useMixedIndex = true;
        this.mixedIndexConfigName = "jgex";
    }

    @Override
    public GraphTraversalSource openGraph() throws ConfigurationException, IOException {
        super.openGraph();
        this.useMixedIndex = this.useMixedIndex && this.conf.containsKey("index." + this.mixedIndexConfigName + ".backend");
        return this.g;
    }

    @Override
    public void dropGraph() throws Exception {
        if (this.graph != null) {
            JanusGraphFactory.drop((JanusGraph)this.getJanusGraph());
        }
    }

    @Override
    public void createElements() {
        super.createElements();
        if (this.useMixedIndex) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected JanusGraph getJanusGraph() {
        return (JanusGraph)this.graph;
    }

    @Override
    public void createSchema() {
        JanusGraphManagement management = this.getJanusGraph().openManagement();
        try {
            if (management.getRelationTypes(RelationType.class).iterator().hasNext()) {
                management.rollback();
                return;
            }
            LOGGER.info("creating schema");
            this.createProperties(management);
            this.createVertexLabels(management);
            this.createEdgeLabels(management);
            this.createCompositeIndexes(management);
            this.createMixedIndexes(management);
            management.commit();
        }
        catch (Exception e) {
            management.rollback();
        }
    }

    protected void createVertexLabels(JanusGraphManagement management) {
        management.makeVertexLabel("titan").make();
        management.makeVertexLabel("location").make();
        management.makeVertexLabel("god").make();
        management.makeVertexLabel("demigod").make();
        management.makeVertexLabel("human").make();
        management.makeVertexLabel("monster").make();
    }

    protected void createEdgeLabels(JanusGraphManagement management) {
        management.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        management.makeEdgeLabel("mother").multiplicity(Multiplicity.MANY2ONE).make();
        management.makeEdgeLabel("lives").signature(new PropertyKey[]{management.getPropertyKey("reason")}).make();
        management.makeEdgeLabel("pet").make();
        management.makeEdgeLabel("brother").make();
        management.makeEdgeLabel("battled").make();
    }

    protected void createProperties(JanusGraphManagement management) {
        management.makePropertyKey("name").dataType(String.class).make();
        management.makePropertyKey("age").dataType(Integer.class).make();
        management.makePropertyKey("time").dataType(Integer.class).make();
        management.makePropertyKey("reason").dataType(String.class).make();
        management.makePropertyKey("place").dataType(Geoshape.class).make();
    }

    protected void createCompositeIndexes(JanusGraphManagement management) {
        management.buildIndex("nameIndex", Vertex.class).addKey(management.getPropertyKey("name")).buildCompositeIndex();
    }

    protected void createMixedIndexes(JanusGraphManagement management) {
        if (this.useMixedIndex) {
            management.buildIndex("vAge", Vertex.class).addKey(management.getPropertyKey("age")).buildMixedIndex(this.mixedIndexConfigName);
            management.buildIndex("eReasonPlace", Edge.class).addKey(management.getPropertyKey("reason")).addKey(management.getPropertyKey("place")).buildMixedIndex(this.mixedIndexConfigName);
        }
    }

    protected String createSchemaRequest() {
        StringBuilder s = new StringBuilder();
        s.append("JanusGraphManagement management = graph.openManagement(); ");
        s.append("boolean created = false; ");
        s.append("if (management.getRelationTypes(RelationType.class).iterator().hasNext()) { management.rollback(); created = false; } else { ");
        s.append("PropertyKey name = management.makePropertyKey(\"name\").dataType(String.class).make(); ");
        s.append("PropertyKey age = management.makePropertyKey(\"age\").dataType(Integer.class).make(); ");
        s.append("PropertyKey time = management.makePropertyKey(\"time\").dataType(Integer.class).make(); ");
        s.append("PropertyKey reason = management.makePropertyKey(\"reason\").dataType(String.class).make(); ");
        s.append("PropertyKey place = management.makePropertyKey(\"place\").dataType(Geoshape.class).make(); ");
        s.append("management.makeVertexLabel(\"titan\").make(); ");
        s.append("management.makeVertexLabel(\"location\").make(); ");
        s.append("management.makeVertexLabel(\"god\").make(); ");
        s.append("management.makeVertexLabel(\"demigod\").make(); ");
        s.append("management.makeVertexLabel(\"human\").make(); ");
        s.append("management.makeVertexLabel(\"monster\").make(); ");
        s.append("management.makeEdgeLabel(\"father\").multiplicity(Multiplicity.MANY2ONE).make(); ");
        s.append("management.makeEdgeLabel(\"mother\").multiplicity(Multiplicity.MANY2ONE).make(); ");
        s.append("management.makeEdgeLabel(\"lives\").signature(reason).make(); ");
        s.append("management.makeEdgeLabel(\"pet\").make(); ");
        s.append("management.makeEdgeLabel(\"brother\").make(); ");
        s.append("management.makeEdgeLabel(\"battled\").make(); ");
        s.append("management.buildIndex(\"nameIndex\", Vertex.class).addKey(name).buildCompositeIndex(); ");
        if (this.useMixedIndex) {
            s.append("management.buildIndex(\"vAge\", Vertex.class).addKey(age).buildMixedIndex(\"").append(this.mixedIndexConfigName).append("\"); ");
            s.append("management.buildIndex(\"eReasonPlace\", Edge.class).addKey(reason).addKey(place).buildMixedIndex(\"").append(this.mixedIndexConfigName).append("\"); ");
        }
        s.append("management.commit(); created = true; }");
        return s.toString();
    }

    public static void main(String[] args) throws Exception {
        String fileName = args != null && args.length > 0 ? args[0] : null;
        boolean drop = args != null && args.length > 1 && "drop".equalsIgnoreCase(args[1]);
        JanusGraphApp app = new JanusGraphApp(fileName);
        if (drop) {
            app.openGraph();
            app.dropGraph();
        } else {
            app.runApp();
        }
    }
}

