/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.blueprints;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.TransactionTest;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedGraph;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.olap.computer.FulgoraElementTraversal;
import org.janusgraph.graphdb.olap.computer.FulgoraVertexProperty;
import org.janusgraph.graphdb.relations.CacheEdge;
import org.janusgraph.graphdb.relations.CacheVertexProperty;
import org.janusgraph.graphdb.relations.SimpleJanusGraphProperty;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.tinkerpop.JanusGraphVariables;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.system.EmptyVertex;
import org.janusgraph.graphdb.types.vertices.EdgeLabelVertex;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.types.vertices.PropertyKeyVertex;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.graphdb.vertices.PreloadedVertex;
import org.janusgraph.graphdb.vertices.StandardVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJanusGraphProvider
extends AbstractGraphProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJanusGraphProvider.class);
    private static final Set<Class> IMPLEMENTATION = Sets.newHashSet((Object[])new Class[]{StandardJanusGraph.class, StandardJanusGraphTx.class, StandardVertex.class, CacheVertex.class, PreloadedVertex.class, EdgeLabelVertex.class, PropertyKeyVertex.class, VertexLabelVertex.class, JanusGraphSchemaVertex.class, EmptyVertex.class, StandardEdge.class, CacheEdge.class, EdgeLabel.class, EdgeLabelVertex.class, StandardVertexProperty.class, CacheVertexProperty.class, SimpleJanusGraphProperty.class, CacheVertexProperty.class, FulgoraVertexProperty.class, JanusGraphVariables.class, FulgoraElementTraversal.class});

    public Set<Class> getImplementations() {
        return IMPLEMENTATION;
    }

    public GraphTraversalSource traversal(Graph graph) {
        return graph.traversal();
    }

    public GraphTraversalSource traversal(Graph graph, TraversalStrategy ... strategies) {
        return graph.traversal().withStrategies(strategies);
    }

    public void clear(Graph g, Configuration configuration) throws Exception {
        CommonsConfiguration config;
        BasicConfiguration readConfig;
        if (null != g) {
            while (g instanceof WrappedGraph) {
                g = (Graph)((WrappedGraph)g).getBaseGraph();
            }
            JanusGraph graph = (JanusGraph)g;
            if (graph.isOpen()) {
                if (g.tx().isOpen()) {
                    g.tx().rollback();
                }
                try {
                    g.close();
                }
                catch (IOException | IllegalStateException e) {
                    logger.warn("Titan graph may not have closed cleanly", (Throwable)e);
                }
            }
        }
        if ((readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)(config = new CommonsConfiguration(configuration)), BasicConfiguration.Restriction.NONE)).has(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0])) {
            JanusGraphBaseTest.clearGraph((WriteConfiguration)config);
        }
    }

    public Map<String, Object> getBaseConfiguration(String graphName, Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
        ModifiableConfiguration conf = this.getJanusGraphConfiguration(graphName, test, testMethodName);
        conf.set(GraphDatabaseConfiguration.COMPUTER_RESULT_MODE, (Object)"persist", new String[0]);
        conf.set(GraphDatabaseConfiguration.AUTO_TYPE, (Object)"tp3", new String[0]);
        HashMap<String, Object> result = new HashMap<String, Object>();
        conf.getAll().forEach((key, value) -> result.put(ConfigElement.getPath((ConfigElement)key.element, (String[])key.umbrellaElements), value));
        result.put("gremlin.graph", JanusGraphFactory.class.getName());
        return result;
    }

    public abstract ModifiableConfiguration getJanusGraphConfiguration(String var1, Class<?> var2, String var3);

    public void loadGraphData(Graph g, LoadGraphWith loadGraphWith, Class testClass, String testName) {
        if (loadGraphWith != null) {
            this.createIndices((JanusGraph)g, loadGraphWith.value());
        } else if (TransactionTest.class.equals((Object)testClass) && testName.equalsIgnoreCase("shouldExecuteWithCompetingThreads")) {
            JanusGraphManagement management = ((JanusGraph)g).openManagement();
            management.makePropertyKey("blah").dataType(Double.class).make();
            management.makePropertyKey("bloop").dataType(Integer.class).make();
            management.makePropertyKey("test").dataType(Object.class).make();
            management.makeEdgeLabel("friend").make();
            management.commit();
        }
        super.loadGraphData(g, loadGraphWith, testClass, testName);
    }

    private void createIndices(JanusGraph g, LoadGraphWith.GraphData graphData) {
        JanusGraphManagement management = g.openManagement();
        if (graphData.equals((Object)LoadGraphWith.GraphData.GRATEFUL)) {
            VertexLabel artist = management.makeVertexLabel("artist").make();
            VertexLabel song = management.makeVertexLabel("song").make();
            PropertyKey name = management.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey songType = management.makePropertyKey("songType").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey performances = management.makePropertyKey("performances").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            management.buildIndex("artistByName", Vertex.class).addKey(name).indexOnly((JanusGraphSchemaType)artist).buildCompositeIndex();
            management.buildIndex("songByName", Vertex.class).addKey(name).indexOnly((JanusGraphSchemaType)song).buildCompositeIndex();
            management.buildIndex("songByType", Vertex.class).addKey(songType).indexOnly((JanusGraphSchemaType)song).buildCompositeIndex();
            management.buildIndex("songByPerformances", Vertex.class).addKey(performances).indexOnly((JanusGraphSchemaType)song).buildCompositeIndex();
        } else if (graphData.equals((Object)LoadGraphWith.GraphData.MODERN)) {
            VertexLabel person = management.makeVertexLabel("person").make();
            VertexLabel software = management.makeVertexLabel("software").make();
            PropertyKey name = management.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey lang = management.makePropertyKey("lang").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey age = management.makePropertyKey("age").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            management.buildIndex("personByName", Vertex.class).addKey(name).indexOnly((JanusGraphSchemaType)person).buildCompositeIndex();
            management.buildIndex("softwareByName", Vertex.class).addKey(name).indexOnly((JanusGraphSchemaType)software).buildCompositeIndex();
            management.buildIndex("personByAge", Vertex.class).addKey(age).indexOnly((JanusGraphSchemaType)person).buildCompositeIndex();
            management.buildIndex("softwareByLang", Vertex.class).addKey(lang).indexOnly((JanusGraphSchemaType)software).buildCompositeIndex();
        } else if (graphData.equals((Object)LoadGraphWith.GraphData.CLASSIC)) {
            PropertyKey name = management.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey lang = management.makePropertyKey("lang").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey age = management.makePropertyKey("age").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            management.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
            management.buildIndex("byAge", Vertex.class).addKey(age).buildCompositeIndex();
            management.buildIndex("byLang", Vertex.class).addKey(lang).buildCompositeIndex();
        }
        management.commit();
    }
}

