/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.KeyValueStoreUtil;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSUtil;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.WriteByteBuffer;

public class KeyColumnValueStoreUtil {
    public static void delete(KeyColumnValueStore store, StoreTransaction txn, long key, String col) throws BackendException {
        StaticBuffer k = KeyColumnValueStoreUtil.longToByteBuffer(key);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer(col);
        store.mutate(k, KeyColumnValueStore.NO_ADDITIONS, Collections.singletonList(c), txn);
    }

    public static String get(KeyColumnValueStore store, StoreTransaction txn, long key, String col) throws BackendException {
        StaticBuffer c;
        StaticBuffer k = KeyColumnValueStoreUtil.longToByteBuffer(key);
        StaticBuffer valBytes = KCVSUtil.get((KeyColumnValueStore)store, (StaticBuffer)k, (StaticBuffer)(c = KeyColumnValueStoreUtil.stringToByteBuffer(col)), (StoreTransaction)txn);
        if (null == valBytes) {
            return null;
        }
        return KeyColumnValueStoreUtil.byteBufferToString(valBytes);
    }

    public static void insert(KeyColumnValueStore store, StoreTransaction txn, long key, String col, String val) throws BackendException {
        StaticBuffer k = KeyColumnValueStoreUtil.longToByteBuffer(key);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer(col);
        StaticBuffer v = KeyColumnValueStoreUtil.stringToByteBuffer(val);
        store.mutate(k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)c, (StaticBuffer)v)), KeyColumnValueStore.NO_DELETIONS, txn);
    }

    public static void loadValues(KeyColumnValueStore store, StoreTransaction tx, String[][] values) throws BackendException {
        KeyColumnValueStoreUtil.loadValues(store, tx, values, -1, -1);
    }

    public static void loadValues(KeyColumnValueStore store, StoreTransaction tx, String[][] values, int shiftEveryNthRow, int shiftSliceLength) throws BackendException {
        for (int i = 0; i < values.length; ++i) {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (int j = 0; j < values[i].length; ++j) {
                StaticBuffer col;
                if (0 < shiftEveryNthRow && 0 == i % shiftEveryNthRow) {
                    ByteBuffer bb = ByteBuffer.allocate(shiftSliceLength + 9);
                    for (int s = 0; s < shiftSliceLength; ++s) {
                        bb.put((byte)-1);
                    }
                    bb.put(KeyValueStoreUtil.getBuffer(j + 1).asByteBuffer());
                    bb.flip();
                    col = StaticArrayBuffer.of((ByteBuffer)bb);
                } else {
                    col = KeyValueStoreUtil.getBuffer(j);
                }
                entries.add(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)KeyValueStoreUtil.getBuffer(values[i][j])));
            }
            if (entries.isEmpty()) continue;
            store.mutate(KeyValueStoreUtil.getBuffer(i), entries, KeyColumnValueStore.NO_DELETIONS, tx);
        }
    }

    public static String byteBufferToString(StaticBuffer b) {
        ByteBuffer bb = b.asByteBuffer();
        return new String(bb.array(), bb.position() + bb.arrayOffset(), bb.remaining(), StandardCharsets.UTF_8);
    }

    public static StaticBuffer stringToByteBuffer(String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(b.length);
        bb.put(b);
        bb.flip();
        return StaticArrayBuffer.of((ByteBuffer)bb);
    }

    public static StaticBuffer longToByteBuffer(long l) {
        return new WriteByteBuffer(8).putLong(l).getStaticBuffer();
    }

    public static long bufferToLong(StaticBuffer b) {
        return b.getLong(0);
    }
}

