/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.commons.configuration.BaseConfiguration;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.KeyValueStoreUtil;
import org.janusgraph.diskstorage.SimpleScanJobRunner;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.Hex;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.junit.jupiter.api.Assertions;

public class SimpleScanJob
implements ScanJob {
    public static final String TOTAL_COUNT = "total";
    public static final String KEY_COUNT = "keys";
    public static final String SETUP_COUNT = "setup";
    public static final String TEARDOWN_COUNT = "teardown";
    public static final ConfigNamespace ROOT_NS = new ConfigNamespace(null, "simplescan", "testing job");
    public static final ConfigOption<String> HEX_QUERIES = new ConfigOption(ROOT_NS, "queries", "comma-delimited, hex-encoded queries", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Long> KEY_FILTER_ID_MODULUS = new ConfigOption(ROOT_NS, "id-modulus", "ID extracted from key must be divisible by this to pass the key filter", ConfigOption.Type.LOCAL, Long.class);
    public static final ConfigOption<Long> KEY_FILTER_ID_MODULAR_VALUE = new ConfigOption(ROOT_NS, "id-modular-value", "ID in modular arithmetic", ConfigOption.Type.LOCAL, Long.class);
    private List<SliceQuery> qs;
    private Predicate<StaticBuffer> keyFilter;

    public SimpleScanJob() {
        this.qs = null;
        this.keyFilter = k -> true;
    }

    public SimpleScanJob(List<SliceQuery> qs, Predicate<StaticBuffer> keyFilter) {
        this.qs = qs;
        this.keyFilter = keyFilter;
    }

    public SimpleScanJob clone() {
        return new SimpleScanJob(this.qs, this.keyFilter);
    }

    public SimpleScanJob(SliceQuery q) {
        this((List<SliceQuery>)ImmutableList.of((Object)q), k -> true);
    }

    public void workerIterationStart(Configuration config, Configuration graphConfig, ScanMetrics metrics) {
        Assertions.assertNotNull((Object)config);
        metrics.incrementCustom(SETUP_COUNT);
        if (config.has(HEX_QUERIES, new String[0])) {
            String[] queryStrings = ((String)config.get(HEX_QUERIES, new String[0])).split(":");
            LinkedList<SliceQuery> queries = new LinkedList<SliceQuery>();
            for (String qString : queryStrings) {
                String[] queryTokens = qString.split("/");
                StaticArrayBuffer start = StaticArrayBuffer.of((byte[])Hex.hexToBytes((String)queryTokens[0]));
                StaticArrayBuffer end = StaticArrayBuffer.of((byte[])Hex.hexToBytes((String)queryTokens[1]));
                SliceQuery query = new SliceQuery((StaticBuffer)start, (StaticBuffer)end);
                int limit = Integer.valueOf(queryTokens[2]);
                if (0 <= limit) {
                    query.setLimit(limit);
                }
                queries.add(query);
            }
            this.qs = queries;
        }
        if (config.has(KEY_FILTER_ID_MODULUS, new String[0])) {
            long mod = (Long)config.get(KEY_FILTER_ID_MODULUS, new String[0]);
            long modVal = config.has(KEY_FILTER_ID_MODULAR_VALUE, new String[0]) ? (Long)config.get(KEY_FILTER_ID_MODULAR_VALUE, new String[0]) : 0L;
            this.keyFilter = k -> (long)KeyValueStoreUtil.getID(k) % mod == modVal;
        }
    }

    public void workerIterationEnd(ScanMetrics metrics) {
        metrics.incrementCustom(TEARDOWN_COUNT);
    }

    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        Assertions.assertNotNull((Object)key);
        Assertions.assertTrue((boolean)this.keyFilter.test(key));
        metrics.incrementCustom(KEY_COUNT);
        Assertions.assertNotNull(entries);
        Assertions.assertTrue((this.qs.size() >= entries.size() ? 1 : 0) != 0);
        for (SliceQuery q : this.qs) {
            if (!entries.containsKey(q)) continue;
            EntryList result = entries.get(q);
            metrics.incrementCustom(TOTAL_COUNT, (long)result.size());
        }
    }

    public List<SliceQuery> getQueries() {
        return this.qs;
    }

    public Predicate<StaticBuffer> getKeyFilter() {
        return this.keyFilter;
    }

    private static String encodeQueries(List<SliceQuery> queries) {
        ArrayList<String> queryStrings = new ArrayList<String>(queries.size());
        for (SliceQuery query : queries) {
            String start = Hex.bytesToHex((byte[])((byte[])query.getSliceStart().as(StaticBuffer.ARRAY_FACTORY)));
            String end = Hex.bytesToHex((byte[])((byte[])query.getSliceEnd().as(StaticBuffer.ARRAY_FACTORY)));
            int limit = query.hasLimit() ? query.getLimit() : -1;
            queryStrings.add(String.format("%s/%s/%d", start, end, limit));
        }
        return Joiner.on((String)":").join(queryStrings);
    }

    public static void runBasicTests(int keys, int columns, SimpleScanJobRunner runner) throws InterruptedException, ExecutionException, BackendException, IOException {
        Configuration conf1 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128))));
        ScanMetrics result1 = runner.run(new SimpleScanJob(), conf1, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)keys, (long)result1.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys * columns / 4 * 3), (long)result1.getCustom(TOTAL_COUNT));
        Assertions.assertEquals((long)result1.getCustom(SETUP_COUNT), (long)result1.getCustom(TEARDOWN_COUNT), (String)"Number of ScanJob setup calls must equal number of ScanJob teardown calls");
        Assertions.assertTrue((0L < result1.getCustom(SETUP_COUNT) ? 1 : 0) != 0, (String)"Number of ScanJob setup/teardown calls must be positive");
        Configuration conf2 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(5)));
        ScanMetrics result2 = runner.run(new SimpleScanJob(), conf2, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)keys, (long)result2.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys * 5), (long)result2.getCustom(TOTAL_COUNT));
        Configuration conf3 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(KeyValueStoreUtil.getBuffer(0), KeyValueStoreUtil.getBuffer(5))));
        ScanMetrics result3 = runner.run(new SimpleScanJob(), conf3, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)keys, (long)result3.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys * 5), (long)result3.getCustom(TOTAL_COUNT));
        Configuration conf4 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(1), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(0), KeyValueStoreUtil.getBuffer(5))));
        ScanMetrics result4 = runner.run(new SimpleScanJob(), conf4, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)keys, (long)result4.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys * 6), (long)result4.getCustom(TOTAL_COUNT));
        Configuration conf5 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(1), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(2), KeyValueStoreUtil.getBuffer(4)), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(6), KeyValueStoreUtil.getBuffer(8)), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(10), KeyValueStoreUtil.getBuffer(20)).setLimit(4)));
        ScanMetrics result5 = runner.run(new SimpleScanJob(), conf5, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)keys, (long)result5.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys * 9), (long)result5.getCustom(TOTAL_COUNT));
        Configuration conf6 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(5)), 2L);
        ScanMetrics result6 = runner.run(new SimpleScanJob(), conf6, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)(keys / 2), (long)result6.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys / 2 * 5), (long)result6.getCustom(TOTAL_COUNT));
        Configuration conf7 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(1), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(2), KeyValueStoreUtil.getBuffer(4)), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(31), KeyValueStoreUtil.getBuffer(35)), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(36), KeyValueStoreUtil.getBuffer(40)).setLimit(1)));
        ScanMetrics result7 = runner.run(new SimpleScanJob(), conf7, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)keys, (long)result7.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys * 3 + keys / 2 * 5), (long)result7.getCustom(TOTAL_COUNT));
        Configuration conf8 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(1), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(31), KeyValueStoreUtil.getBuffer(35))), 2L, 1L);
        ScanMetrics result8 = runner.run(new SimpleScanJob(), conf8, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)(keys / 2), (long)result8.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys / 2 * 5), (long)result8.getCustom(TOTAL_COUNT));
        Configuration conf9 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128)).setLimit(1), (Object)new SliceQuery(KeyValueStoreUtil.getBuffer(31), KeyValueStoreUtil.getBuffer(35))), 2L);
        ScanMetrics result9 = runner.run(new SimpleScanJob(), conf9, SimpleScanJob.class.getName() + "#ROOT_NS");
        Assertions.assertEquals((long)(keys / 2), (long)result9.getCustom(KEY_COUNT));
        Assertions.assertEquals((long)(keys / 2), (long)result9.getCustom(TOTAL_COUNT));
        try {
            Configuration conf10 = SimpleScanJob.getJobConf((List<SliceQuery>)ImmutableList.of((Object)new SliceQuery((StaticBuffer)StaticArrayBuffer.of((byte[])new byte[]{2}), BufferUtil.oneBuffer((int)1)), (Object)new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)1))));
            runner.run(new SimpleScanJob(), conf10, SimpleScanJob.class.getName() + "#ROOT_NS");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Configuration getJobConf(List<SliceQuery> queries) {
        return SimpleScanJob.getJobConf(queries, null, null);
    }

    public static Configuration getJobConf(List<SliceQuery> queries, Long modulus) {
        return SimpleScanJob.getJobConf(queries, modulus, null);
    }

    public static Configuration getJobConf(List<SliceQuery> queries, Long modulus, Long modVal) {
        ModifiableConfiguration conf2 = new ModifiableConfiguration(ROOT_NS, (WriteConfiguration)new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
        if (null != queries) {
            conf2.set(HEX_QUERIES, (Object)SimpleScanJob.encodeQueries(queries), new String[0]);
        }
        if (null != modulus) {
            conf2.set(KEY_FILTER_ID_MODULUS, (Object)modulus, new String[0]);
        }
        if (null != modVal) {
            conf2.set(KEY_FILTER_ID_MODULAR_VALUE, (Object)modVal, new String[0]);
        }
        return conf2;
    }
}

