/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.log;

import java.time.Duration;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.log.LogManager;
import org.janusgraph.diskstorage.log.LogTest;
import org.janusgraph.diskstorage.log.kcvs.KCVSLogManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class KCVSLogTest
extends LogTest {
    public static final String LOG_NAME = "testlog";
    private KeyColumnValueStoreManager storeManager;

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    @Override
    public LogManager openLogManager(String senderId, boolean requiresOrderPreserving) throws BackendException {
        this.storeManager = this.openStorageManager();
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)senderId, new String[0]);
        config.set(GraphDatabaseConfiguration.LOG_READ_INTERVAL, (Object)Duration.ofMillis(500L), new String[]{LOG_NAME});
        config.set(KCVSLogManager.LOG_FIXED_PARTITION, (Object)requiresOrderPreserving, new String[]{LOG_NAME});
        return new KCVSLogManager(this.storeManager, config.restrictTo(new String[]{LOG_NAME}));
    }

    @Override
    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        super.setup(testInfo);
    }

    @Override
    @AfterEach
    public void shutdown(TestInfo testInfo) throws Exception {
        super.shutdown(testInfo);
        this.storeManager.close();
    }
}

