/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GraphDatabaseConfigurationInstanceIdTest {
    @Test
    public void graphShouldOpenWithSameInstanceId() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "inmemory");
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID.toStringWithoutRoot(), "not-unique");
        map.put(GraphDatabaseConfiguration.REPLACE_INSTANCE_IF_EXISTS.toStringWithoutRoot(), true);
        MapConfiguration config = new MapConfiguration(map);
        StandardJanusGraph graph1 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)graph1.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)graph1.openManagement().getOpenInstances().toArray()[0], (Object)"not-unique");
        StandardJanusGraph graph2 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)graph1.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)graph1.openManagement().getOpenInstances().toArray()[0], (Object)"not-unique");
        Assertions.assertEquals((int)graph2.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)graph2.openManagement().getOpenInstances().toArray()[0], (Object)"not-unique");
        graph1.close();
        graph2.close();
    }

    @Test
    public void graphShouldNotOpenWithSameInstanceId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "inmemory");
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID.toStringWithoutRoot(), "not-unique");
        MapConfiguration config = new MapConfiguration(map);
        StandardJanusGraph graph1 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)graph1.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)graph1.openManagement().getOpenInstances().toArray()[0], (Object)"not-unique");
        JanusGraphException janusGraphException = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> {
            StandardJanusGraph graph2 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph1.close();
        });
        Assertions.assertEquals((Object)"A JanusGraph graph with the same instance id [not-unique] is already open. Might required forced shutdown.", (Object)janusGraphException.getMessage());
    }

    @Test
    public void instanceIdShouldEqualHostname() throws UnknownHostException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "inmemory");
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        MapConfiguration config = new MapConfiguration(map);
        StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)graph.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)graph.openManagement().getOpenInstances().toArray()[0], (Object)Inet4Address.getLocalHost().getHostName());
        graph.close();
    }

    @Test
    public void instanceIdShouldEqualHostnamePlusSuffix() throws UnknownHostException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "inmemory");
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_SUFFIX.toStringWithoutRoot(), 1);
        MapConfiguration config = new MapConfiguration(map);
        StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)graph.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)graph.openManagement().getOpenInstances().toArray()[0], (Object)(Inet4Address.getLocalHost().getHostName() + "1"));
        graph.close();
    }
}

