/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.apache.tinkerpop.gremlin.util.Gremlin;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.SequentialLongIterator;
import org.janusgraph.graphdb.SpeedTestSchema;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.query.QueryUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroovySpeedTestSupport
implements GroovyObject {
    private static final Logger log;
    public static final int VERTEX_COUNT = 1000;
    public static final int EDGE_COUNT = 5000;
    public static final int DEFAULT_TX_COUNT = 3;
    public static final int DEFAULT_VERTICES_PER_TX = 100;
    public static final int DEFAULT_ITERATIONS = 300;
    public static final String RELATION_FILE = "../janusgraph-test/data/v10k.graphml.gz";
    protected Random random;
    protected SpeedTestSchema schema;
    protected JanusGraph graph;
    protected WriteConfiguration conf;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GroovySpeedTestSupport(WriteConfiguration conf) throws BackendException {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Random.class, 7);
        this.random = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        WriteConfiguration writeConfiguration = conf;
        this.conf = IndyInterface.bootstrap("cast", "()", 0, writeConfiguration);
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, GroovySpeedTestSupport.class);
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        IndyInterface.bootstrap("invoke", "load", 0, Gremlin.class);
    }

    @BeforeEach
    public void open() {
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)this.graph)) {
            try {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getGraph", 2, this);
                this.graph = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
            catch (BackendException e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, e));
            }
        }
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)this.schema)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "getSchema", 2, this);
            this.schema = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
    }

    @AfterEach
    public void rollback() {
        if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)this.graph)) {
            IndyInterface.bootstrap("invoke", "rollback", 0, this.graph);
        }
    }

    public void close() {
        if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)this.graph)) {
            IndyInterface.bootstrap("invoke", "shutdown", 0, this.graph);
        }
    }

    protected abstract StandardJanusGraph getGraph() throws BackendException;

    protected abstract SpeedTestSchema getSchema();

    protected void sequentialUidTask(int verticesPerTx, Object closure) {
        Reference closure2 = new Reference(closure);
        public final class _sequentialUidTask_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference closure;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _sequentialUidTask_closure1(Object _outerInstance, Object _thisObject, Reference closure) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.closure = reference = closure;
            }

            public Object doCall(Object tx, Object vbuf, Object vloaded) {
                ValueRecorder valueRecorder = new ValueRecorder();
                try {
                    Integer n = 1;
                    Object object = vloaded;
                    valueRecorder.record(object, 13);
                    boolean bl = ScriptBytecodeAdapter.compareEqual((Object)n, (Object)object);
                    valueRecorder.record((Object)bl, 10);
                    if (bl) {
                        valueRecorder.clear();
                    } else {
                        ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert 1 == vloaded", (ValueRecorder)valueRecorder), null);
                    }
                }
                catch (Throwable throwable) {
                    valueRecorder.clear();
                    throw throwable;
                }
                ValueRecorder valueRecorder2 = new ValueRecorder();
                try {
                    Integer n = 1;
                    Object object = vbuf;
                    valueRecorder2.record(object, 13);
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "length", 0, object);
                    valueRecorder2.record((Object)callSite, 18);
                    boolean bl = ScriptBytecodeAdapter.compareEqual((Object)n, (Object)callSite);
                    valueRecorder2.record((Object)bl, 10);
                    if (bl) {
                        valueRecorder2.clear();
                    } else {
                        ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert 1 == vbuf.length", (ValueRecorder)valueRecorder2), null);
                    }
                }
                catch (Throwable throwable) {
                    valueRecorder2.clear();
                    throw throwable;
                }
                CallSite v = IndyInterface.bootstrap("invoke", "getAt", 0, vbuf, false);
                return IndyInterface.bootstrap("invoke", "call", 0, this.closure.get(), tx, v);
            }

            public Object call(Object tx, Object vbuf, Object vloaded) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, vbuf, vloaded);
            }

            public Object getClosure() {
                return this.closure.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _sequentialUidTask_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "chunkedSequentialUidTask", 2, this, true, verticesPerTx, new _sequentialUidTask_closure1(this, this, closure2));
    }

    protected void chunkedSequentialUidTask(int chunksize, int verticesPerTx, Object closure) {
        IndyInterface.bootstrap("invoke", "checkArgument", 0, Preconditions.class, ScriptBytecodeAdapter.compareEqual((Object)0, (Object)IndyInterface.bootstrap("invoke", "mod", 0, verticesPerTx, chunksize)));
        long count = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, DEFAULT_TX_COUNT, verticesPerTx));
        long offset = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "mod", 0, IndyInterface.bootstrap("invoke", "abs", 0, Math.class, IndyInterface.bootstrap("invoke", "nextLong", 0, this.random)), IndyInterface.bootstrap("invoke", "getMaxUid", 0, this.schema)));
        CallSite uids = IndyInterface.bootstrap("init", "<init>", 0, SequentialLongIterator.class, count, IndyInterface.bootstrap("invoke", "getMaxUid", 0, this.schema), offset);
        CallSite tx = IndyInterface.bootstrap("invoke", "newTransaction", 0, this.graph);
        JanusGraphVertex[] vbuf = new JanusGraphVertex[chunksize];
        int vloaded = 0;
        while (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasNext", 0, uids)) != false) {
            CallSite callSite;
            int n;
            long u = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, uids));
            CallSite v = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getOnlyElement", 0, Iterables.class, IndyInterface.bootstrap("invoke", "getVertices", 0, QueryUtil.class, tx, IndyInterface.bootstrap("getProperty", "UID_PROP", 0, IndyInterface.bootstrap("getProperty", "Schema", 12, this)), u)));
            IndyInterface.bootstrap("invoke", "assertNotNull", 2, this, v);
            CallSite callSite2 = v;
            int n2 = vloaded;
            vloaded = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n2));
            IndyInterface.bootstrap("invoke", "putAt", 0, vbuf, n2, callSite2);
            if (!(vloaded == chunksize)) continue;
            IndyInterface.bootstrap("invoke", "call", 0, closure, tx, vbuf, vloaded);
            vloaded = n = 0;
            IndyInterface.bootstrap("invoke", "commit", 0, tx);
            tx = callSite = IndyInterface.bootstrap("invoke", "newTransaction", 0, this.graph);
        }
        if (0 < vloaded) {
            IndyInterface.bootstrap("invoke", "call", 0, closure, tx, vbuf, vloaded);
            IndyInterface.bootstrap("invoke", "commit", 0, tx);
        } else {
            IndyInterface.bootstrap("invoke", "rollback", 0, tx);
        }
    }

    protected void supernodeTask(Object closure) {
        long uid = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "getSupernodeUid", 0, this.schema));
        CallSite label = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSupernodeOutLabel", 0, this.schema));
        IndyInterface.bootstrap("invoke", "assertNotNull", 2, this, label);
        CallSite pkey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSortKeyForLabel", 0, this.schema, label));
        IndyInterface.bootstrap("invoke", "assertNotNull", 2, this, pkey);
        CallSite tx = IndyInterface.bootstrap("invoke", "newTransaction", 0, this.graph);
        CallSite v = IndyInterface.bootstrap("invoke", "getOnlyElement", 0, Iterables.class, IndyInterface.bootstrap("invoke", "getVertices", 0, QueryUtil.class, tx, IndyInterface.bootstrap("getProperty", "UID_PROP", 0, IndyInterface.bootstrap("getProperty", "Schema", 12, this)), uid));
        IndyInterface.bootstrap("invoke", "assertNotNull", 2, this, v);
        IndyInterface.bootstrap("invoke", "call", 0, closure, v, label, pkey);
        IndyInterface.bootstrap("invoke", "commit", 0, tx);
    }

    protected void standardIndexEdgeTask(Object closure) {
        int keyCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getEdgePropKeys", 0, this.schema));
        CallSite tx = IndyInterface.bootstrap("invoke", "newTransaction", 0, this.graph);
        int value = -1;
        int p = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)p, (Object)IndyInterface.bootstrap("invoke", "getEdgePropKeys", 0, this.schema))) {
            int i = 0;
            while (i < 5) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "next", 0, value);
                value = DefaultTypeTransformation.intUnbox((Object)callSite);
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "getMaxEdgePropVal", 0, this.schema))) {
                    int n;
                    value = n = 0;
                }
                IndyInterface.bootstrap("invoke", "call", 0, closure, tx, IndyInterface.bootstrap("invoke", "getEdgePropertyName", 0, this.schema, p), value);
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            int n = p;
            p = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        IndyInterface.bootstrap("invoke", "commit", 0, tx);
    }

    protected void standardIndexVertexTask(Object closure) {
        int keyCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getVertexPropKeys", 0, this.schema));
        CallSite tx = IndyInterface.bootstrap("invoke", "newTransaction", 0, this.graph);
        int value = -1;
        int p = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)p, (Object)IndyInterface.bootstrap("invoke", "getVertexPropKeys", 0, this.schema))) {
            int i = 0;
            while (i < 5) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "next", 0, value);
                value = DefaultTypeTransformation.intUnbox((Object)callSite);
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "getMaxVertexPropVal", 0, this.schema))) {
                    int n;
                    value = n = 0;
                }
                IndyInterface.bootstrap("invoke", "call", 0, closure, tx, IndyInterface.bootstrap("invoke", "getVertexPropertyName", 0, this.schema, p), value);
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            int n = p;
            p = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        IndyInterface.bootstrap("invoke", "commit", 0, tx);
    }

    protected void initializeGraph(JanusGraph g) throws BackendException {
        IndyInterface.bootstrap("invoke", "info", 0, log, "Initializing graph...");
        long before = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
        CallSite schema = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSchema", 2, this));
        try {
            CallSite data = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GZIPInputStream.class, IndyInterface.bootstrap("init", "<init>", 0, FileInputStream.class, RELATION_FILE)));
            IndyInterface.bootstrap("invoke", "makeTypes", 0, schema, g);
            IndyInterface.bootstrap("invoke", "inputGraph", 0, IndyInterface.bootstrap("getProperty", "GraphMLReader", 12, this), g, data);
        }
        catch (IOException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, e));
        }
        long after = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
        long duration = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, after, before));
        if (ScriptBytecodeAdapter.compareLessThanEqual((Object)IndyInterface.bootstrap("invoke", "multiply", 0, 15, 1000), (Object)duration)) {
            IndyInterface.bootstrap("invoke", "warn", 0, log, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Initialized graph (", duration), " ms)."));
        } else {
            IndyInterface.bootstrap("invoke", "info", 0, log, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Initialized graph (", duration), " ms)."));
        }
    }

    @Generated
    protected void sequentialUidTask(Object closure) {
        Reference closure2 = new Reference(closure);
        this.sequentialUidTask(DEFAULT_VERTICES_PER_TX, closure2.get());
    }

    @Generated
    protected void chunkedSequentialUidTask(int chunksize, Object closure) {
        this.chunkedSequentialUidTask(chunksize, DEFAULT_VERTICES_PER_TX, closure);
    }

    @Generated
    protected void chunkedSequentialUidTask(Object closure) {
        this.chunkedSequentialUidTask(DEFAULT_VERTICES_PER_TX, DEFAULT_VERTICES_PER_TX, closure);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GroovySpeedTestSupport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

