/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.log.TransactionRecovery;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexInformation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.JanusGraphTest;
import org.janusgraph.graphdb.TestMockIndexProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.log.StandardTransactionLogProcessor;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphIndexTest
extends JanusGraphBaseTest {
    private static final ElementValueComparator ORDER_AGE_DESC = new ElementValueComparator("age", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc);
    private static final ElementValueComparator ORDER_AGE_ASC = new ElementValueComparator("age", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc);
    private static final ElementValueComparator ORDER_LENGTH_DESC = new ElementValueComparator("length", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc);
    private static final ElementValueComparator ORDER_LENGTH_ASC = new ElementValueComparator("length", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc);
    public static final String INDEX = "search";
    public static final String VINDEX = "vsearch";
    public static final String EINDEX = "esearch";
    public static final String PINDEX = "psearch";
    private static final int RETRY_COUNT = 30;
    private static final long RETRY_INTERVAL = 1000L;
    public final boolean supportsGeoPoint;
    public final boolean supportsNumeric;
    public final boolean supportsText;
    public IndexFeatures indexFeatures;
    private static final Logger log = LoggerFactory.getLogger(JanusGraphIndexTest.class);

    protected JanusGraphIndexTest(boolean supportsGeoPoint, boolean supportsNumeric, boolean supportsText) {
        this.supportsGeoPoint = supportsGeoPoint;
        this.supportsNumeric = supportsNumeric;
        this.supportsText = supportsText;
    }

    private Parameter getStringMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.STRING)) {
            return Mapping.STRING.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"String mapping not supported");
    }

    private Parameter getTextMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXT)) {
            return Mapping.TEXT.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"Text mapping not supported");
    }

    private Parameter getFieldMap(PropertyKey key) {
        return ParameterType.MAPPED_NAME.getParameter((Object)key.name());
    }

    public abstract boolean supportsLuceneStyleQueries();

    public abstract boolean supportsWildcardQuery();

    @Override
    public void open(WriteConfiguration config) {
        super.open(config);
        this.indexFeatures = (IndexFeatures)this.graph.getBackend().getIndexFeatures().get(INDEX);
    }

    @Override
    public void clopen(Object ... settings) {
        this.graph.tx().commit();
        super.clopen(settings);
    }

    @Test
    public void testGraphOfTheGods() {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph);
        JanusGraphIndexTest.assertGraphOfTheGods((JanusGraph)this.graph);
    }

    public static void assertGraphOfTheGods(JanusGraph graphOfTheGods) {
        JanusGraphAssert.assertCount(12, graphOfTheGods.query().vertices());
        JanusGraphAssert.assertCount(3, graphOfTheGods.query().has(LABEL_NAME, (Object)"god").vertices());
        JanusGraphVertex h = JanusGraphIndexTest.getOnlyVertex(graphOfTheGods.query().has("name", (Object)"hercules"));
        Assertions.assertEquals((int)30, (int)((Integer)h.value("age")));
        Assertions.assertEquals((Object)"demigod", (Object)h.label());
        JanusGraphAssert.assertCount(5, h.query().direction(Direction.BOTH).edges());
        graphOfTheGods.tx().commit();
    }

    @Test
    public void testNullQueries() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        PropertyKey p4 = this.makeKey("p4", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(p4, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p4", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p4", P.neq(null)).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p4", null).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p4").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p4").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p4", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p4", (Object)"value").vertices().iterator().hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p4")).hasNext());
    }

    @Test
    public void testClearStorage() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph);
        this.tearDown();
        this.config.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DROP_ON_CLEAR, (String[])new String[0]), (Object)true);
        Backend backend = JanusGraphIndexTest.getBackend(this.config, false);
        JanusGraphIndexTest.assertStorageExists(backend, true);
        JanusGraphIndexTest.clearGraph(this.config);
        try {
            backend.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (Backend newBackend = JanusGraphIndexTest.getBackend(this.config, false);){
            JanusGraphIndexTest.assertStorageExists(newBackend, false);
        }
    }

    private static void assertStorageExists(Backend backend, boolean exists) throws Exception {
        String suffix = exists ? "should exist before clearing" : "should not exist after clearing";
        Assertions.assertEquals((Object)backend.getStoreManager().exists(), (Object)exists, (String)("graph " + suffix));
        for (IndexInformation index : backend.getIndexInformation().values()) {
            Assertions.assertEquals((Object)((IndexProvider)index).exists(), (Object)exists, (String)("index " + suffix));
        }
    }

    @Test
    public void testSimpleUpdate() {
        PropertyKey name = this.makeKey("name", String.class);
        this.makeLabel("knows");
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("namee", Edge.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        JanusGraphEdge e = v.addEdge("knows", (Vertex)v, new Object[]{"name", "Hulu Bubab"});
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assertions.assertEquals((Object)"Marko Rodriguez", (Object)u.value("name"));
        }
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assertions.assertEquals((Object)"Marko Rodriguez", (Object)u.value("name"));
        }
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.single, "name", (Object)"Marko", new Object[0]);
        e = JanusGraphIndexTest.getOnlyEdge(v.query().direction(Direction.OUT));
        e.property("name", (Object)"Tubu Rubu");
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Rubu").edges());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assertions.assertEquals((Object)"Marko", (Object)u.value("name"));
        }
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Rubu").edges());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assertions.assertEquals((Object)"Marko", (Object)u.value("name"));
        }
    }

    @Test
    public void testListUpdate() {
        if (!this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING);
        PropertyKey alias = this.mgmt.makePropertyKey("alias").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).addKey(alias, new Parameter[]{this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) ? Mapping.TEXTSTRING.asParameter() : Mapping.DEFAULT.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.list, "alias", (Object)"Marko", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.list, "alias", (Object)"mRodriguez", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Marko").vertices());
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"mRodriguez").vertices());
        }
    }

    @Test
    public void testSetUpdate() {
        if (!this.indexFeatures.supportsCardinality(Cardinality.SET)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey alias = this.mgmt.makePropertyKey("alias").dataType(String.class).cardinality(Cardinality.SET).make();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).addKey(alias, new Parameter[]{this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) ? Mapping.TEXTSTRING.asParameter() : Mapping.DEFAULT.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.set, "alias", (Object)"Marko", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.set, "alias", (Object)"mRodriguez", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Marko").vertices());
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"mRodriguez").vertices());
        }
    }

    @Test
    public void testListDeleteAddInOneTransaction() {
        if (!this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey aliasKey = this.mgmt.makePropertyKey("alias").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).addKey(aliasKey, new Parameter[]{this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) ? Mapping.TEXTSTRING.asParameter() : Mapping.DEFAULT.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        this.clopen(new Object[0]);
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko Rodriguez"));
        v.property("alias", (Object)"Marko");
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko Rodriguez"));
        v.property("alias").remove();
        v.property("alias", (Object)"Marko1");
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko1").vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko1").vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
    }

    @Test
    public void testIndexing() throws InterruptedException {
        int numV;
        PropertyKey text = this.makeKey("text", String.class);
        this.createExternalVertexIndex(text, INDEX);
        this.createExternalEdgeIndex(text, INDEX);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.addIndexKey(this.getExternalIndex(Vertex.class, INDEX), name, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.TEXT)});
        this.mgmt.addIndexKey(this.getExternalIndex(Edge.class, INDEX), name, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.TEXT)});
        PropertyKey location = this.makeKey("location", Geoshape.class);
        this.createExternalVertexIndex(location, INDEX);
        this.createExternalEdgeIndex(location, INDEX);
        PropertyKey boundary = this.makeKey("boundary", Geoshape.class);
        this.mgmt.addIndexKey(this.getExternalIndex(Vertex.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.PREFIX_TREE), Parameter.of((String)"index-geo-dist-error-pct", (Object)0.0025)});
        this.mgmt.addIndexKey(this.getExternalIndex(Edge.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.PREFIX_TREE), Parameter.of((String)"index-geo-dist-error-pct", (Object)0.0025)});
        PropertyKey time = this.makeKey("time", Long.class);
        this.createExternalVertexIndex(time, INDEX);
        this.createExternalEdgeIndex(time, INDEX);
        PropertyKey category = this.makeKey("category", Integer.class);
        this.mgmt.buildIndex("vcategory", Vertex.class).addKey(category).buildCompositeIndex();
        this.mgmt.buildIndex("ecategory", Edge.class).addKey(category).buildCompositeIndex();
        PropertyKey group = this.makeKey("group", Byte.class);
        this.createExternalVertexIndex(group, INDEX);
        this.createExternalEdgeIndex(group, INDEX);
        this.makeVertexIndexedKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{time}).signature(new PropertyKey[]{location, boundary}).make();
        this.finishSchema();
        this.clopen(new Object[0]);
        String[] words = new String[]{"world", "aurelius", "janusgraph", "graph"};
        int numCategories = 5;
        int numGroups = 10;
        int originalNumV = numV = 100;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.tx.addVertex(new Object[0]);
            v.property(VertexProperty.Cardinality.single, "uid", (Object)i, new Object[0]);
            v.property(VertexProperty.Cardinality.single, "category", (Object)(i % 5), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "group", (Object)(i % 10), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "text", (Object)("Vertex " + words[i % words.length]), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "name", (Object)words[i % words.length], new Object[0]);
            v.property(VertexProperty.Cardinality.single, "time", (Object)i, new Object[0]);
            double offset = (double)(i % 2 == 0 ? 1 : -1) * ((double)i * 50.0 / (double)numV);
            v.property(VertexProperty.Cardinality.single, "location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)), new Object[0]);
            if (i % 2 == 0) {
                v.property(VertexProperty.Cardinality.single, "boundary", (Object)Geoshape.line(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1})), new Object[0]);
            } else {
                v.property(VertexProperty.Cardinality.single, "boundary", (Object)Geoshape.polygon(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1}, {offset - 0.1, offset - 0.1})), new Object[0]);
            }
            JanusGraphEdge e = v.addEdge("knows", (Vertex)this.getVertex("uid", (Object)Math.max(0, i - 1)), new Object[0]);
            e.property("text", (Object)("Vertex " + words[i % words.length]));
            e.property("name", (Object)words[i % words.length]);
            e.property("time", (Object)i);
            e.property("category", (Object)(i % 5));
            e.property("group", (Object)(i % 10));
            e.property("location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)));
            if (i % 2 == 0) {
                e.property("boundary", (Object)Geoshape.line(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1})));
                continue;
            }
            e.property("boundary", (Object)Geoshape.polygon(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1}, {offset - 0.1, offset - 0.1})));
        }
        this.checkIndexingCounts(words, numV, originalNumV, true);
        int status = 1;
        for (int retry = 0; retry < 30 && status > 0; ++retry) {
            this.clopen(new Object[0]);
            try {
                this.checkIndexingCounts(words, numV, originalNumV, true);
                status = 0;
                continue;
            }
            catch (AssertionError e) {
                if (retry >= 29) {
                    throw e;
                }
                Thread.sleep(1000L);
            }
        }
        this.newTx();
        int numDelete = 12;
        for (int i = numV - 12; i < numV; ++i) {
            this.getVertex("uid", (Object)i).remove();
        }
        this.checkIndexingCounts(words, numV -= 12, originalNumV, false);
    }

    private void checkIndexingCounts(String[] words, int numV, int originalNumV, boolean checkOrder) {
        int i;
        for (String word : words) {
            int expectedSize = numV / words.length;
            JanusGraphAssert.assertCount(expectedSize, this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).vertices());
            JanusGraphAssert.assertCount(expectedSize, this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).edges());
            if (!checkOrder) continue;
            for (String orderKey : new String[]{"time", "category"}) {
                for (Order order : Order.values()) {
                    for (JanusGraphQuery traversal : ImmutableList.of((Object)this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).orderBy(orderKey, order.getTP()), (Object)this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).orderBy(orderKey, order.getTP()))) {
                        JanusGraphIndexTest.verifyElementOrder(traversal.vertices(), orderKey, order, expectedSize);
                    }
                }
            }
        }
        JanusGraphAssert.assertCount(3, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(3).vertices());
        JanusGraphAssert.assertCount(3, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(3).edges());
        for (i = 0; i < numV / 2; i += numV / 10) {
            JanusGraphAssert.assertCount(i, this.tx.query().has("time", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)(i + i)).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("time", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)(i + i)).edges());
        }
        for (i = 0; i < numV; i += 5) {
            this.testGeo(i, originalNumV, numV);
        }
        JanusGraphAssert.assertCount(4, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).vertices());
        JanusGraphAssert.assertCount(4, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).edges());
        JanusGraphAssert.assertCount(5, this.tx.query().has("time", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)30).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        double offset = 950.0 / (double)originalNumV;
        double distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        JanusGraphAssert.assertCount(5, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        JanusGraphAssert.assertCount(5, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().edges());
        JanusGraphAssert.assertCount(numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"world").vertices());
        JanusGraphAssert.assertCount(numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"world").edges());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"world").vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"world").edges());
        JanusGraphAssert.assertCount(numV - numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"world").vertices());
        JanusGraphAssert.assertCount(numV - numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"world").edges());
        JanusGraphAssert.assertCount(numV, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"world").vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"world").edges());
    }

    @Test
    public void testBooleanIndexing() {
        PropertyKey name = this.makeKey("visible", Boolean.class);
        this.mgmt.buildIndex("booleanIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("visible", (Object)true);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("visible", (Object)false);
        JanusGraphAssert.assertCount(2, this.graph.vertices(new Object[0]));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)true)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)false)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)true)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)false)));
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(2, this.graph.vertices(new Object[0]));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)true)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)false)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)true)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)false)));
    }

    @Test
    public void testDateIndexing() {
        PropertyKey name = this.makeKey("date", Date.class);
        this.mgmt.buildIndex("dateIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("date", (Object)new Date(1L));
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("date", (Object)new Date(2000L));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(1L))));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)new Date(1L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)new Date(1L)).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)new Date(2000L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)new Date(2000L)).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)new Date(1L))));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(1L))));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)new Date(1L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)new Date(1L)).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)new Date(2000L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)new Date(2000L)).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)new Date(1L))));
    }

    @Test
    public void testInstantIndexing() {
        PropertyKey name = this.makeKey("instant", Instant.class);
        this.mgmt.buildIndex("instantIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        Instant firstTimestamp = Instant.ofEpochMilli(1L);
        Instant secondTimestamp = Instant.ofEpochMilli(2000L);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("instant", (Object)firstTimestamp);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("instant", (Object)secondTimestamp);
        this.testInstant(firstTimestamp, secondTimestamp, v1, v2);
        firstTimestamp = Instant.ofEpochSecond(0L, 1L);
        v1 = (JanusGraphVertex)this.graph.vertices(new Object[]{v1.id()}).next();
        v1.property("instant", (Object)firstTimestamp);
        if (this.indexFeatures.supportsNanoseconds()) {
            this.testInstant(firstTimestamp, secondTimestamp, v1, v2);
        } else {
            this.clopen(new Object[0]);
            try {
                Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
                Assertions.fail((String)"Should have failed to update the index");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void testInstant(Instant firstTimestamp, Instant secondTimestamp, JanusGraphVertex v1, JanusGraphVertex v2) {
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)firstTimestamp).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)secondTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)secondTimestamp).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)firstTimestamp)));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)firstTimestamp).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)secondTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)secondTimestamp).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)firstTimestamp)));
    }

    @Test
    public void testUUIDIndexing() {
        PropertyKey name = this.makeKey("uid", UUID.class);
        this.mgmt.buildIndex("uuidIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        UUID uid1 = UUID.randomUUID();
        UUID uid2 = UUID.randomUUID();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("uid", (Object)uid1);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("uid", (Object)uid2);
        JanusGraphAssert.assertCount(2, this.graph.query().vertices());
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid1)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid2)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid1)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid2)));
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(2, this.graph.query().vertices());
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid1)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid2)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid1)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid2)));
    }

    @Test
    public void testConditionalIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("org").make();
        JanusGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
        JanusGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).indexOnly((JanusGraphSchemaType)person).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        JanusGraphIndex index3 = this.mgmt.buildIndex("index3", Vertex.class).indexOnly((JanusGraphSchemaType)org).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        JanusGraphAssert.assertCount(3, this.mgmt.getGraphIndexes(Vertex.class));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assertions.assertEquals((Object)"index2", (Object)index2.name());
        Assertions.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assertions.assertFalse((boolean)index2.isUnique());
        Assertions.assertEquals((int)2, (int)index3.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)index1.getFieldKeys().length);
        Assertions.assertEquals((int)3, (int)index3.getParametersFor(text).length);
        Assertions.assertEquals((int)2, (int)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        JanusGraphAssert.assertCount(3, this.mgmt.getGraphIndexes(Vertex.class));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assertions.assertEquals((Object)"index2", (Object)index2.name());
        Assertions.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assertions.assertFalse((boolean)index2.isUnique());
        Assertions.assertEquals((int)2, (int)index3.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)index1.getFieldKeys().length);
        Assertions.assertEquals((int)3, (int)index3.getParametersFor(text).length);
        Assertions.assertEquals((int)2, (int)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        weight = this.tx.getPropertyKey("weight");
        int numV = 200;
        String[] strings = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] stringsTwo = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsTwo[i] = strings[i] + " " + strings[i];
        }
        int modulo = 5;
        Assertions.assertEquals((int)0, (int)(200 % (5 * strings.length * 2)));
        for (int i = 0; i < 200; ++i) {
            JanusGraphVertex v = this.tx.addVertex(i % 2 == 0 ? "person" : "org");
            v.property("name", (Object)strings[i % strings.length]);
            v.property("text", (Object)strings[i % strings.length]);
            v.property("weight", (Object)((double)(i % 5) + 0.5));
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[1]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / (5 * strings.length), new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.ASC, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[1]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / (5 * strings.length), new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.ASC, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
    }

    @Test
    public void testCompositeAndMixedIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey text = this.makeKey("text", String.class);
        this.makeKey("flag", Boolean.class);
        JanusGraphIndex composite = this.mgmt.buildIndex("composite", Vertex.class).addKey(name).addKey(weight).buildCompositeIndex();
        JanusGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(weight).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        mixed.name();
        composite.name();
        this.finishSchema();
        int numV = 100;
        String[] strings = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] stringsTwo = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsTwo[i] = strings[i] + " " + strings[i];
        }
        int modulo = 5;
        int divisor = 5 * strings.length;
        for (int i = 0; i < 100; ++i) {
            JanusGraphVertex v = this.tx.addVertex(new Object[0]);
            v.property("name", (Object)strings[i % strings.length]);
            v.property("text", (Object)strings[i % strings.length]);
            v.property("weight", (Object)((double)(i % 5) + 0.5));
            v.property("flag", (Object)true);
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("flag"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name(), composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name(), composite.name());
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("flag"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name(), composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name(), composite.name());
    }

    private void setupChainGraph(int numV, String[] strings, boolean sameNameMapping) {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, INDEX), sameNameMapping);
        JanusGraphIndex vindex = this.getExternalIndex(Vertex.class, INDEX);
        JanusGraphIndex eindex = this.getExternalIndex(Edge.class, INDEX);
        JanusGraphIndex pindex = this.getExternalIndex(JanusGraphVertexProperty.class, INDEX);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.addIndexKey(vindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(eindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(pindex, name, new Parameter[]{this.getStringMapping(), Parameter.of((String)"mapped-name", (Object)"xstr")});
        PropertyKey text = this.makeKey("text", String.class);
        this.mgmt.addIndexKey(vindex, text, new Parameter[]{this.getTextMapping(), Parameter.of((String)"mapped-name", (Object)"xtext")});
        this.mgmt.addIndexKey(eindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.addIndexKey(pindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.makeEdgeLabel("knows").signature(new PropertyKey[]{name}).make();
        this.mgmt.makePropertyKey("uid").dataType(String.class).signature(new PropertyKey[]{text}).make();
        this.finishSchema();
        JanusGraphVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{"name", strings[i % strings.length], "text", strings[i % strings.length]});
            v.addEdge("knows", (Vertex)(previous == null ? v : previous), new Object[]{"name", strings[i % strings.length], "text", strings[i % strings.length]});
            v.property("uid", (Object)("v" + i), new Object[]{"name", strings[i % strings.length], "text", strings[i % strings.length]});
            previous = v;
        }
    }

    @Test
    public void testIndexParameters() {
        int numV = 1000;
        String[] strings = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(1000, strings, false);
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, 1000 / strings.length * 2, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, 1000 / strings.length, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, 1000 / strings.length * 2, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, 1000 / strings.length, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, 1000 / strings.length * 2, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").properties());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, 1000 / strings.length, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has(LABEL_NAME, (Object)"uid").has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties());
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, 1000 / strings.length * 2, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, 1000 / strings.length, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, 1000 / strings.length * 2, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, 1000 / strings.length, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, 1000 / strings.length * 2, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").properties());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, 1000 / strings.length, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has(LABEL_NAME, (Object)"uid").has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties());
        if (this.supportsLuceneStyleQueries()) {
            JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "xtext:ducks").vertexStream());
            JanusGraphAssert.assertCount(0L, this.graph.indexQuery(EINDEX, "xtext:ducks").edgeStream());
        }
    }

    @Test
    public void testRawQueries() {
        if (!this.supportsLuceneStyleQueries()) {
            return;
        }
        int numV = 1000;
        String[] strings = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(1000, strings, true);
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "v.text:ducks").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry)").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length), this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry) AND v.name:\"Uncle Berry has a farm\"").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2 - 10), this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").offset(10).vertexStream());
        long total = this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(Integer.MAX_VALUE).vertexStream().count();
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).vertexStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).vertexTotals());
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(10).vertexStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(10).vertexTotals());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(1000).vertexStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(1000).vertexTotals());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "xtext:ducks").vertexStream());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(VINDEX, "text:ducks").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "$v$text:ducks").setElementIdentifier("$v$").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "e.text:ducks").edgeStream());
        total = this.graph.indexQuery(EINDEX, "e.text:ducks").limit(Integer.MAX_VALUE).edgeStream().count();
        Assertions.assertEquals((float)total, (float)(1000L / (long)strings.length * 2L), (float)this.graph.indexQuery(EINDEX, "e.text:ducks").edgeTotals().longValue());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry)").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length), this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry) AND e.name:\"Uncle Berry has a farm\"").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2 - 10), this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").offset(10).edgeStream());
        total = this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(Integer.MAX_VALUE).edgeStream().count();
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).edgeStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).edgeTotals());
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(10).edgeStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(10).edgeTotals());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(1000).edgeStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(1000).edgeTotals());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "text:ducks").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "p.text:ducks").propertyStream());
        total = this.graph.indexQuery(PINDEX, "p.text:ducks").limit(Integer.MAX_VALUE).propertyStream().count();
        Assertions.assertEquals((float)total, (float)(1000L / (long)strings.length * 2L), (float)this.graph.indexQuery(PINDEX, "p.text:ducks").propertyTotals().longValue());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry)").propertyStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length), this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry) AND p.name:\"Uncle Berry has a farm\"").propertyStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").propertyStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2 - 10), this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").offset(10).propertyStream());
        total = this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(Integer.MAX_VALUE).propertyStream().count();
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).propertyStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).propertyTotals());
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(10).propertyStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(10).propertyTotals());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(1000).propertyStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(1000).propertyTotals());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "text:ducks").propertyStream());
    }

    @Test
    public void testRawQueriesWithParameters() {
        String backend;
        if (!this.supportsLuceneStyleQueries()) {
            return;
        }
        Parameter asc_sort_p = null;
        Parameter desc_sort_p = null;
        switch (backend = (String)this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX})) {
            case "elasticsearch": {
                HashMap<String, String> sortAsc = new HashMap<String, String>();
                sortAsc.put("_score", "asc");
                asc_sort_p = new Parameter("sort", Collections.singletonList(sortAsc));
                HashMap<String, String> sortDesc = new HashMap<String, String>();
                sortDesc.put("_score", "desc");
                desc_sort_p = new Parameter("sort", Collections.singletonList(sortDesc));
                break;
            }
            case "solr": {
                asc_sort_p = new Parameter("sort", (Object)new String[]{"score asc"});
                desc_sort_p = new Parameter("sort", (Object)new String[]{"score desc"});
                break;
            }
            case "lucene": {
                return;
            }
            default: {
                Assertions.fail((String)("Unknown index backend:" + backend));
            }
        }
        PropertyKey field1Key = this.mgmt.makePropertyKey("field1").dataType(String.class).make();
        this.mgmt.buildIndex("store1", Vertex.class).addKey(field1Key).buildMixedIndex(INDEX);
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v1.property("field1", (Object)"Hello Hello Hello Hello Hello Hello Hello Hello world");
        v2.property("field1", (Object)"Hello blue and yellow meet green");
        v3.property("field1", (Object)"Hello Hello world world");
        this.tx.commit();
        List vertices = this.graph.indexQuery("store1", "v.field1:(Hello)").addParameter(asc_sort_p).vertexStream().map(JanusGraphIndexQuery.Result::getElement).collect(Collectors.toList());
        JanusGraphAssert.assertNotEmpty(vertices);
        AtomicInteger idx = new AtomicInteger(vertices.size() - 1);
        this.graph.indexQuery("store1", "v.field1:(Hello)").addParameter(desc_sort_p).vertexStream().map(JanusGraphIndexQuery.Result::getElement).forEachOrdered(e -> Assertions.assertEquals(vertices.get(idx.getAndDecrement()), (Object)e));
    }

    @Test
    public void testDualMapping() {
        if (!this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        JanusGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{Mapping.TEXTSTRING.asParameter()}).buildMixedIndex(INDEX);
        mixed.name();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "Long John Don"});
        this.tx.addVertex(new Object[]{"name", "Long Little Lewis"});
        this.tx.addVertex(new Object[]{"name", "Middle Sister Mabel"});
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Long John Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"Lon"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"Lit*le"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"Long.*"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"Middle"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.FUZZY, (Object)"Long john Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS_FUZZY, (Object)"Midle"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        for (Vertex u : this.tx.getVertices(new long[0])) {
            String n = (String)u.value("name");
            if (n.endsWith("Don")) {
                u.remove();
                continue;
            }
            if (n.endsWith("Lewis")) {
                u.property(VertexProperty.Cardinality.single, "name", (Object)"Big Brother Bob", new Object[0]);
                continue;
            }
            if (!n.endsWith("Mabel")) continue;
            u.property("name").remove();
        }
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"Middle"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    public void testIndexReplay() throws Exception {
        TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        Instant startTime = times.getTime();
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), Duration.ofSeconds(1L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.STORAGE_WRITE_WAITTIME, new String[0]), Duration.ofMillis(300L), JanusGraphIndexTest.option(TestMockIndexProvider.INDEX_BACKEND_PROXY, INDEX), this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX}), JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_BACKEND, INDEX), TestMockIndexProvider.class.getName(), JanusGraphIndexTest.option(TestMockIndexProvider.INDEX_MOCK_FAILADD, INDEX), true);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey age = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("mi", Vertex.class).addKey(name, new Parameter[]{this.getTextMapping()}).addKey(age).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex[] vs = new JanusGraphVertex[4];
        vs[0] = this.tx.addVertex(new Object[]{"name", "Big Boy Bobson", "age", 55});
        this.newTx();
        vs[1] = this.tx.addVertex(new Object[]{"name", "Long Little Lewis", "age", 35});
        vs[2] = this.tx.addVertex(new Object[]{"name", "Tall Long Tiger", "age", 75});
        vs[3] = this.tx.addVertex(new Object[]{"name", "Long John Don", "age", 15});
        this.newTx();
        vs[2] = JanusGraphIndexTest.getV((Transaction)this.tx, vs[2]);
        vs[2].remove();
        vs[3] = JanusGraphIndexTest.getV((Transaction)this.tx, vs[3]);
        vs[3].property(VertexProperty.Cardinality.single, "name", (Object)"Bad Boy Badsy", new Object[0]);
        vs[3].property("age").remove();
        this.newTx();
        vs[0] = JanusGraphIndexTest.getV((Transaction)this.tx, vs[0]);
        vs[0].property(VertexProperty.Cardinality.single, "age", (Object)66, new Object[0]);
        this.newTx();
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        TransactionRecovery recovery = JanusGraphFactory.startTransactionRecovery((JanusGraph)this.graph, (Instant)startTime);
        Thread.sleep(12000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"long"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"long").interval("age", (Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(40)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("age", (Object)75), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"boy").interval("age", (Comparable)Integer.valueOf(60), (Comparable)Integer.valueOf(70)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("age", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        Assertions.assertEquals((long)1L, (long)recoveryStats[0]);
        Assertions.assertEquals((long)4L, (long)recoveryStats[1]);
    }

    @Test
    public void testIndexUpdatesWithoutReindex() throws InterruptedException, ExecutionException {
        Object[] settings = new Object[]{JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L)};
        this.clopen(settings);
        String defText = "Mountain rocks are great friends";
        int defTime = 5;
        double defHeight = 101.1;
        String[] defPhones = new String[]{"1234", "5678"};
        this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.makePropertyKey("height").dataType(Double.class).make();
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            this.mgmt.makePropertyKey("phone").dataType(String.class).cardinality(Cardinality.LIST).make();
        }
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(text, new Parameter[]{this.getTextMapping(), this.getFieldMap(text)}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey time = this.mgmt.getPropertyKey("time");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), time, new Parameter[]{this.getFieldMap(time)});
        this.finishSchema();
        this.newTx();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        Assertions.assertNull((Object)this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX));
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REGISTER_INDEX).get();
        this.mgmt.commit();
        ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX).get();
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 3, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey height = this.mgmt.getPropertyKey("height");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), height, new Parameter[0]);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            PropertyKey phone = this.mgmt.getPropertyKey("phone");
            this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), phone, new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)});
        }
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        JanusGraphIndex index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)index.getIndexStatus(key));
        }
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 4, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        }
        this.newTx();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REINDEX).get();
        this.mgmt.commit();
        this.finishSchema();
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        }
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.DISABLE_INDEX).get();
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)index.getIndexStatus(key));
        }
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{false, true}, new String[0]);
    }

    private void addVertex(int time, String text, double height, String[] phones) {
        this.newTx();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"text", text, "time", time, "height", height});
        for (String phone : phones) {
            v.property("phone", (Object)phone);
        }
        this.newTx();
    }

    @Test
    public void testVertexTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel event = this.mgmt.makeVertexLabel("event").setStatic().make();
        int eventTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((JanusGraphSchemaType)event, Duration.ofSeconds(eventTTLSeconds));
        this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Vertex.class).indexOnly((JanusGraphSchemaType)event).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)time));
        Assertions.assertEquals((Object)Duration.ofSeconds(eventTTLSeconds), (Object)this.mgmt.getTTL((JanusGraphSchemaType)event));
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("event");
        v1.property(VertexProperty.Cardinality.single, "name", (Object)"first event", new Object[0]);
        v1.property(VertexProperty.Cardinality.single, "text", (Object)"this text will help to identify the first event", new Object[0]);
        long time1 = System.currentTimeMillis();
        v1.property(VertexProperty.Cardinality.single, "time", (Object)time1, new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex("event");
        v2.property(VertexProperty.Cardinality.single, "name", (Object)"second event", new Object[0]);
        v2.property(VertexProperty.Cardinality.single, "text", (Object)"this text won't match", new Object[0]);
        long time2 = time1 + 1L;
        v2.property(VertexProperty.Cardinality.single, "time", (Object)time2, new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        this.clopen(new Object[0]);
        Object v1Id = v1.id();
        Object v2Id = v2.id();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1Id);
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v1Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 1.25), TimeUnit.SECONDS));
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "index2");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 0, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1Id);
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v2Id);
        Assertions.assertNull((Object)v1);
        Assertions.assertNull((Object)v2);
    }

    @Test
    public void testEdgeTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        PropertyKey time = this.makeKey("time", Long.class);
        EdgeLabel label = this.mgmt.makeEdgeLabel("likes").make();
        int likesTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((JanusGraphSchemaType)label, Duration.ofSeconds(likesTTLSeconds));
        this.mgmt.buildIndex("index1", Edge.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Edge.class).indexOnly((JanusGraphSchemaType)label).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ofSeconds(likesTTLSeconds), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label));
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        JanusGraphEdge e1 = v1.addEdge("likes", (Vertex)v2, new Object[]{"name", "v1 likes v2", "text", "this will help to identify the edge"});
        long time1 = System.currentTimeMillis();
        e1.property("time", (Object)time1);
        JanusGraphEdge e2 = v2.addEdge("likes", (Vertex)v3, new Object[]{"name", "v2 likes v3", "text", "this won't match anything"});
        long time2 = time1 + 1L;
        e2.property("time", (Object)time2);
        this.tx.commit();
        this.clopen(new Object[0]);
        Object e1Id = e1.id();
        e2.id();
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"likes"), ElementCategory.EDGE, 1, new boolean[]{true, true}, "index2");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.EDGE, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1.id());
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v2.id());
        v3 = JanusGraphIndexTest.getV((Transaction)this.tx, v3.id());
        e1 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        e2 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v3);
        Assertions.assertNotNull((Object)e1);
        Assertions.assertNotNull((Object)e2);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).edges());
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)likesTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"likes"), ElementCategory.EDGE, 0, new boolean[]{true, true}, "index2");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.EDGE, 0, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1.id());
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v2.id());
        v3 = JanusGraphIndexTest.getV((Transaction)this.tx, v3.id());
        e1 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        e2 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v3);
        Assertions.assertNull((Object)e1);
        Assertions.assertNull((Object)e2);
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertEmpty(v2.query().direction(Direction.OUT).edges());
    }

    @Test
    public void testDeleteVertexThenDeleteProperty(TestInfo testInfo) throws BackendException {
        this.testNestedWrites("x", null, testInfo);
    }

    @Test
    public void testDeleteVertexThenAddProperty(TestInfo testInfo) throws BackendException {
        this.testNestedWrites(null, "y", testInfo);
    }

    @Test
    public void testDeleteVertexThenModifyProperty(TestInfo testInfo) throws BackendException {
        this.testNestedWrites("x", "y", testInfo);
    }

    @Test
    public void testIndexQueryWithScore() throws InterruptedException {
        PropertyKey textKey = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.buildIndex("store1", Vertex.class).addKey(textKey).buildMixedIndex(INDEX);
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v1.property("text", (Object)"Hello Hello Hello Hello Hello Hello Hello Hello world");
        v2.property("text", (Object)"Hello abab abab fsdfsd sfdfsd sdffs fsdsdf fdf fsdfsd aera fsad abab abab fsdfsd sfdf");
        v3.property("text", (Object)"Hello Hello world world");
        this.tx.commit();
        Set scores = this.graph.indexQuery("store1", "v.text:(Hello)").vertexStream().map(JanusGraphIndexQuery.Result::getScore).collect(Collectors.toSet());
        Assertions.assertEquals((int)3, (int)scores.size());
    }

    @Test
    public void testContainsWithMultipleValues() throws Exception {
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.buildIndex("store1", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property("name", (Object)"hercules was here");
        this.tx.commit();
        JanusGraphVertex r = (JanusGraphVertex)Iterables.get((Iterable)this.graph.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"hercules here").vertices(), (int)0);
        Assertions.assertEquals((Object)r.property("name").value(), (Object)"hercules was here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNestedWrites(String initialValue, String updatedValue, TestInfo testInfo) throws BackendException {
        Backend b = null;
        try {
            b = this.graph.getConfiguration().getBackend();
            if (b.getStoreFeatures().hasTxIsolation()) {
                log.info("Skipping " + this.getClass().getSimpleName() + "." + testInfo.getTestMethod().toString());
                return;
            }
        }
        finally {
            if (null != b) {
                b.close();
            }
        }
        String propName = "foo";
        PropertyKey prop = this.makeKey("foo", String.class);
        this.createExternalVertexIndex(prop, INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.graph.addVertex(new Object[0]);
        if (null != initialValue) {
            v.property(VertexProperty.Cardinality.single, "foo", (Object)initialValue, new Object[0]);
        }
        this.graph.tx().commit();
        Object id = v.id();
        JanusGraphTransaction vertexDeleter = this.graph.newTransaction();
        JanusGraphTransaction propDeleter = this.graph.newTransaction();
        JanusGraphIndexTest.getV((Transaction)vertexDeleter, id).remove();
        if (null == updatedValue) {
            JanusGraphIndexTest.getV((Transaction)propDeleter, id).property("foo").remove();
        } else {
            JanusGraphIndexTest.getV((Transaction)propDeleter, id).property(VertexProperty.Cardinality.single, "foo", (Object)updatedValue, new Object[0]);
        }
        vertexDeleter.commit();
        propDeleter.commit();
        this.graph.tx().rollback();
        Assertions.assertNull((Object)JanusGraphIndexTest.getV((Transaction)this.graph, id));
        JanusGraphAssert.assertEmpty(this.graph.query().has("foo").vertices());
        if (null != updatedValue) {
            JanusGraphAssert.assertEmpty(this.graph.query().has("foo", (Object)updatedValue).vertices());
        }
        this.graph.tx().rollback();
    }

    @Test
    public void testWidcardQuery() {
        if (this.supportsWildcardQuery()) {
            PropertyKey p1 = this.makeKey("p1", String.class);
            PropertyKey p2 = this.makeKey("p2", String.class);
            this.mgmt.buildIndex("mixedIndex", Vertex.class).addKey(p1).addKey(p2).buildMixedIndex(INDEX);
            this.finishSchema();
            this.clopen(new Object[0]);
            JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
            v1.property("p1", (Object)"test1");
            v1.property("p2", (Object)"test2");
            this.clopen(new Object[0]);
            Assertions.assertEquals((Object)v1, (Object)((JanusGraphIndexQuery.Result)this.graph.indexQuery("mixedIndex", "v.*:\"test1\"").vertexStream().findFirst().orElseThrow(IllegalStateException::new)).getElement());
            Assertions.assertEquals((Object)v1, (Object)((JanusGraphIndexQuery.Result)this.graph.indexQuery("mixedIndex", "v.*:\"test2\"").vertexStream().findFirst().orElseThrow(IllegalStateException::new)).getElement());
        }
    }

    @Test
    public void testListIndexing() {
        this.testIndexing(Cardinality.LIST);
    }

    protected abstract boolean supportsCollections();

    protected boolean supportsGeoCollections() {
        return true;
    }

    @Test
    public void testSetIndexing() {
        this.testIndexing(Cardinality.SET);
    }

    private void testIndexing(Cardinality cardinality) {
        if (this.supportsCollections()) {
            String backend;
            PropertyKey stringProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(cardinality).make();
            PropertyKey intProperty = this.mgmt.makePropertyKey("age").dataType(Integer.class).cardinality(cardinality).make();
            PropertyKey longProperty = this.mgmt.makePropertyKey("long").dataType(Long.class).cardinality(cardinality).make();
            PropertyKey uuidProperty = this.mgmt.makePropertyKey("uuid").dataType(UUID.class).cardinality(cardinality).make();
            JanusGraphManagement.IndexBuilder indexBuilder = this.mgmt.buildIndex("collectionIndex", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).addKey(intProperty).addKey(longProperty).addKey(uuidProperty);
            if (this.supportsGeoCollections()) {
                PropertyKey geopointProperty = this.mgmt.makePropertyKey("geopoint").dataType(Geoshape.class).cardinality(cardinality).make();
                indexBuilder.addKey(geopointProperty);
            }
            indexBuilder.buildMixedIndex(INDEX);
            this.finishSchema();
            this.testCollection(cardinality, "name", "Totoro", "Hiro");
            this.testCollection(cardinality, "age", 1, 2);
            this.testCollection(cardinality, "long", 1L, 2L);
            if (this.supportsGeoCollections()) {
                this.testCollection(cardinality, "geopoint", Geoshape.point((double)1.0, (double)1.0), Geoshape.point((double)2.0, (double)2.0));
            }
            if (!"solr".equals(backend = (String)this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX}))) {
                this.testCollection(cardinality, "uuid", UUID.randomUUID(), UUID.randomUUID());
            }
        } else {
            try {
                PropertyKey stringProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(cardinality).make();
                this.mgmt.buildIndex("collectionIndex", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (JanusGraphException janusGraphException) {
                // empty catch block
            }
        }
    }

    private void testCollection(Cardinality cardinality, String property, Object value1, Object value2) {
        this.clopen(new Object[0]);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property(property, value1);
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.property(property, value2);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.properties(new String[]{property}).forEachRemaining(p -> {
            if (p.value().equals(value1)) {
                p.remove();
            }
        });
        Assertions.assertFalse((boolean)this.graph.query().has(property, value1).vertices().iterator().hasNext());
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        Assertions.assertFalse((boolean)this.graph.query().has(property, value1).vertices().iterator().hasNext());
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.property(property, value1);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.property(property, value1);
        Assertions.assertEquals((int)(Cardinality.SET.equals((Object)cardinality) ? 2 : 3), (int)Iterators.size((Iterator)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has(property, value1)).properties(new String[]{property})));
        this.clopen(new Object[0]);
        Assertions.assertEquals((int)(Cardinality.SET.equals((Object)cardinality) ? 2 : 3), (int)Iterators.size((Iterator)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has(property, value1)).properties(new String[]{property})));
        this.graph.vertices(new Object[0]).forEachRemaining(Element::remove);
        v1 = this.graph.addVertex(new Object[0]);
        v1.property(property, value1);
        v1.property(property, value2);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        if (value1 instanceof Geoshape && this.supportsGeoCollections()) {
            Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)1.0, (double)1.0, (double)0.1)).vertices()));
            Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)2.0, (double)2.0, (double)0.1)).vertices()));
        }
        GraphTraversalSource g = this.graph.traversal();
        g.V(new Object[0]).drop().iterate();
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        v1 = (Vertex)g.addV().property((Object)property, value1, new Object[0]).property((Object)property, value2, new Object[0]).next();
        g.addV().property((Object)property, value1, new Object[0]).property((Object)property, value2, new Object[0]).next();
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        Assertions.assertEquals((int)2, (int)g.V(new Object[0]).has(property, value1).toList().size());
        g.V(new Object[0]).properties(new String[0]).drop().iterate();
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        Assertions.assertFalse((boolean)g.V(new Object[0]).has(property, value1).hasNext());
        Assertions.assertFalse((boolean)g.V(new Object[0]).has(property, value2).hasNext());
    }

    private void testGeo(int i, int origNumV, int numV) {
        double offset = (double)i * 50.0 / (double)origNumV;
        double bufferKm = 20.0;
        double distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        if (i > 0) {
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)(distance - 20.0))).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)(distance - 20.0))).edges());
        }
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        if (this.indexFeatures.supportsGeoContains()) {
            JanusGraphAssert.assertCount(i % 2, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)(-offset), (double)(-offset))).vertices());
            JanusGraphAssert.assertCount(i % 2, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)(-offset), (double)(-offset))).edges());
        }
        double buffer = 0.18018018018018017;
        double min = -Math.abs(offset);
        double max = Math.abs(offset);
        Geoshape bufferedBox = Geoshape.box((double)(min - 0.18018018018018017), (double)(min - 0.18018018018018017), (double)(max + 0.18018018018018017), (double)(max + 0.18018018018018017));
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)bufferedBox).edges());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).edges());
        if (i > 0) {
            Geoshape exactBox = Geoshape.box((double)min, (double)min, (double)max, (double)max);
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactBox).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactBox).edges());
        }
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).edges());
        Geoshape bufferedPoly = Geoshape.polygon(Arrays.asList({min - 0.18018018018018017, min - 0.18018018018018017}, {max + 0.18018018018018017, min - 0.18018018018018017}, {max + 0.18018018018018017, max + 0.18018018018018017}, {min - 0.18018018018018017, max + 0.18018018018018017}, {min - 0.18018018018018017, min - 0.18018018018018017}));
        if (i > 0) {
            Geoshape exactPoly = Geoshape.polygon(Arrays.asList({min, min}, {max, min}, {max, max}, {min, max}, {min, min}));
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactPoly).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactPoly).edges());
        }
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedPoly).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedPoly).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedPoly).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedPoly).edges());
    }

    @Test
    public void shouldAwaitMultipleStatuses() throws InterruptedException, ExecutionException {
        PropertyKey key1 = this.makeKey("key1", String.class);
        JanusGraphIndex index = this.mgmt.buildIndex("randomMixedIndex", Vertex.class).addKey(key1).buildMixedIndex(INDEX);
        if (index.getIndexStatus(key1) == SchemaStatus.INSTALLED) {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("randomMixedIndex"), SchemaAction.REGISTER_INDEX).get();
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("randomMixedIndex"), SchemaAction.ENABLE_INDEX).get();
        } else if (index.getIndexStatus(key1) == SchemaStatus.REGISTERED) {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("randomMixedIndex"), SchemaAction.ENABLE_INDEX).get();
        }
        PropertyKey key2 = this.makeKey("key2", String.class);
        this.mgmt.addIndexKey(index, key2, new Parameter[0]);
        this.mgmt.commit();
        try {
            ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"randomMixedIndex").status(new SchemaStatus[]{SchemaStatus.REGISTERED, SchemaStatus.ENABLED})).call();
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to awaitGraphIndexStatus on multiple statuses.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAndForceIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey nameProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("oridx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).addKey(ageProperty).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            GraphTraversalSource g = customGraph.traversal();
            g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).next();
            g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
            customGraph.tx().commit();
            JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("name", (Object)"Totoro"));
            JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("age", (Object)2));
            JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"age", (Object)2)}));
            JanusGraphAssert.assertCount(0, (Traversal)g.V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}));
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexUniqueMixedIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey nameProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey lengthProperty = management.makePropertyKey("length").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("oridx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).addKey(ageProperty).addKey(lengthProperty).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            this.testOr((Graph)customGraph);
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexMixedAndCompositeIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey nameProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey lengthProperty = management.makePropertyKey("length").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("nameidx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
            management.buildIndex("ageridx", Vertex.class).addKey(ageProperty).buildCompositeIndex();
            management.buildIndex("lengthidx", Vertex.class).addKey(lengthProperty).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            this.testOr((Graph)customGraph);
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    @Test
    public void testOrPartialIndex() {
        PropertyKey nameProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey lengthProperty = this.mgmt.makePropertyKey("length").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("otheridx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).addKey(lengthProperty).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        this.testOr((Graph)this.graph);
    }

    private void testOr(Graph aGraph) {
        GraphTraversalSource g = aGraph.traversal();
        Vertex hiro = (Vertex)g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).property((Object)"length", (Object)90, new Object[0]).next();
        Vertex totoro = (Vertex)g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
        Vertex john = (Vertex)g.addV().property((Object)"name", (Object)"John", new Object[0]).property((Object)"age", (Object)3, new Object[0]).property((Object)"length", (Object)110, new Object[0]).next();
        Vertex mike = (Vertex)g.addV().property((Object)"name", (Object)"Mike", new Object[0]).property((Object)"age", (Object)4, new Object[0]).property((Object)"length", (Object)130, new Object[0]).next();
        aGraph.tx().commit();
        JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("name", (Object)"Totoro"));
        JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("age", (Object)2));
        JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertCount(2, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertCount(2, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro").has("age", (Object)1), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertCount(2, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.and((Traversal[])new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)1)}), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.lte((Object)100)).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (P)P.gte((Object)2))}), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (P)P.gte((Object)2))}).has("length", P.lte((Object)100)), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}).order().by((Comparator)ORDER_AGE_DESC), (Element[])new Vertex[]{hiro, totoro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{totoro, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"age", (Object)2)}).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_DESC)}), (Element[])new Vertex[]{totoro, john, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_ASC)}), (Element[])new Vertex[]{totoro, hiro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"John"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_ASC)}), (Element[])new Vertex[]{john, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_AGE_DESC)}), (Element[])new Vertex[]{totoro, john, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_AGE_ASC)}), (Element[])new Vertex[]{totoro, hiro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_DESC)}).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{totoro, hiro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_ASC)}).order().by((Comparator)ORDER_AGE_DESC), (Element[])new Vertex[]{john, hiro, totoro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120))}).order().by((Comparator)ORDER_AGE_ASC).limit(2L), (Element[])new Vertex[]{totoro, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120))}).order().by((Comparator)ORDER_AGE_ASC).range(2L, 3L), (Element[])new Vertex[]{john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).limit(1L)}), (Element[])new Vertex[]{totoro, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).limit(1L)}), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).range(1L, 2L)}), (Element[])new Vertex[]{totoro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).range(1L, 3L)}).limit(2L), (Element[])new Vertex[]{totoro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.gte((Object)130).or((Predicate)P.lt((Object)100))).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro, mike});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.gte((Object)80).and((Predicate)P.gte((Object)130).or((Predicate)P.lt((Object)100)))).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro, mike});
        if (this.indexFeatures.supportNotQueryNormalForm()) {
            JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.gte((Object)80).and((Predicate)P.gte((Object)130)).or((Predicate)P.gte((Object)80).and((Predicate)P.lt((Object)100)))).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro, mike});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexPartialIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey stringProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("oridx", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            GraphTraversalSource g = customGraph.traversal();
            g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).next();
            g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
            customGraph.tx().commit();
            g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}).hasNext();
            Assertions.fail((String)"should fail");
        }
        catch (JanusGraphException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Could not find a suitable index to answer graph query and graph scans are disabled"));
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    @Test
    public void testIndexDataRetrievalWithLimitLessThenBatch() throws Exception {
        WriteConfiguration config = this.getConfiguration();
        config.set("index.search.max-result-set-size", (Object)10);
        JanusGraph customGraph = this.getForceIndexGraph(config);
        JanusGraphManagement management = customGraph.openManagement();
        PropertyKey num = management.makePropertyKey("num").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        management.buildIndex("oridx", Vertex.class).addKey(num).buildMixedIndex(INDEX);
        management.commit();
        customGraph.tx().commit();
        GraphTraversalSource g = customGraph.traversal();
        g.addV().property((Object)"num", (Object)1, new Object[0]).next();
        g.addV().property((Object)"num", (Object)2, new Object[0]).next();
        customGraph.tx().commit();
        Assertions.assertEquals((int)2, (int)customGraph.traversal().V(new Object[0]).has("num", P.lt((Object)3)).limit(4L).toList().size());
        JanusGraphFactory.close((Graph)customGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexComposite() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("ageridx", Vertex.class).addKey(ageProperty).buildCompositeIndex();
            management.commit();
            customGraph.tx().commit();
            GraphTraversalSource g = customGraph.traversal();
            g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).next();
            g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
            customGraph.tx().commit();
            g.V(new Object[0]).has("age", P.gte((Object)4).or((Predicate)P.lt((Object)2))).hasNext();
            Assertions.fail((String)"should fail");
        }
        catch (JanusGraphException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Could not find a suitable index to answer graph query and graph scans are disabled"));
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }
}

