/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.JtsGeoshapeHelper;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.JanusGraphIndexTest;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistryV1d0;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public abstract class JanusGraphIoTest
extends JanusGraphBaseTest {
    private static final GeometryFactory GF = new GeometryFactory();
    private static final JtsGeoshapeHelper HELPER = new JtsGeoshapeHelper();
    private static final Function<Geoshape, Geoshape> makePoly = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.polygon(Arrays.asList({x, y}, {x, y + 1.0}, {x + 1.0, y + 1.0}, {x + 1.0, y}, {x, y}, {x, y}));
    };
    private static final Function<Geoshape, Geoshape> makeLine = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.line(Arrays.asList({x, y}, {x, y + 1.0}, {x + 1.0, y + 1.0}, {x + 1.0, y}));
    };
    private static final Function<Geoshape, Geoshape> makeMultiPoint = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return HELPER.geoshape((Geometry)GF.createMultiPoint(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + 1.0, y + 1.0)}));
    };
    private static final Function<Geoshape, Geoshape> makeMultiLine = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return HELPER.geoshape((Geometry)GF.createMultiLineString(new LineString[]{GF.createLineString(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + 1.0, y + 1.0)}), GF.createLineString(new Coordinate[]{new Coordinate(x - 1.0, y - 1.0), new Coordinate(x, y)})}));
    };
    private static final Function<Geoshape, Geoshape> makeMultiPolygon = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return HELPER.geoshape((Geometry)GF.createMultiPolygon(new Polygon[]{GF.createPolygon(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + 1.0, y), new Coordinate(x + 1.0, y + 1.0), new Coordinate(x, y)}), GF.createPolygon(new Coordinate[]{new Coordinate(x + 2.0, y + 2.0), new Coordinate(x + 2.0, y + 3.0), new Coordinate(x + 3.0, y + 3.0), new Coordinate(x + 2.0, y + 2.0)})}));
    };

    static Stream<Arguments> data() {
        GraphSONMapper v1mapper = GraphSONMapper.build().version(GraphSONVersion.V1_0).typeInfo(TypeInfo.PARTIAL_TYPES).addRegistry((IoRegistry)JanusGraphIoRegistryV1d0.instance()).create();
        GraphSONMapper v2mapper = GraphSONMapper.build().version(GraphSONVersion.V2_0).typeInfo(TypeInfo.PARTIAL_TYPES).addRegistry((IoRegistry)JanusGraphIoRegistry.instance()).create();
        GraphSONMapper v3mapper = GraphSONMapper.build().version(GraphSONVersion.V3_0).typeInfo(TypeInfo.PARTIAL_TYPES).addRegistry((IoRegistry)JanusGraphIoRegistry.instance()).create();
        return Stream.of(Arguments.arguments((Object[])new Object[]{"graphson-v1-embedded", g -> GraphSONReader.build().mapper((Mapper)v1mapper).create(), g -> GraphSONWriter.build().mapper((Mapper)v1mapper).create()}), Arguments.arguments((Object[])new Object[]{"graphson-v2-embedded", g -> GraphSONReader.build().mapper((Mapper)v2mapper).create(), g -> GraphSONWriter.build().mapper((Mapper)v2mapper).create()}), Arguments.arguments((Object[])new Object[]{"graphson-v3", g -> GraphSONReader.build().mapper((Mapper)v3mapper).create(), g -> GraphSONWriter.build().mapper((Mapper)v3mapper).create()}), Arguments.arguments((Object[])new Object[]{"gryo", g -> ((GryoIo)g.io(IoCore.gryo())).reader().mapper((Mapper)((GryoIo)g.io(IoCore.gryo())).mapper().create()).create(), g -> ((GryoIo)g.io(IoCore.gryo())).writer().mapper((Mapper)((GryoIo)g.io(IoCore.gryo())).mapper().create()).create()}));
    }

    @BeforeEach
    public void setup() {
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        JanusGraphManagement management = this.graph.openManagement();
        management.makePropertyKey("shape").dataType(Geoshape.class).make();
        management.commit();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSerialization(String name, Function<Graph, GraphReader> readerMaker, Function<Graph, GraphWriter> writerMaker) throws Exception {
        this.testSerializationSpecialized("nullFunction", null, readerMaker, writerMaker);
        this.testSerializationSpecialized("makeLine", makeLine, readerMaker, writerMaker);
        this.testSerializationSpecialized("makePoly", makePoly, readerMaker, writerMaker);
        this.testSerializationSpecialized("makeMultiPoint", makeMultiPoint, readerMaker, writerMaker);
        this.testSerializationSpecialized("makeMultiLine", makeMultiLine, readerMaker, writerMaker);
        this.testSerializationSpecialized("makeMultiPolygon", makeMultiPolygon, readerMaker, writerMaker);
    }

    private void testSerializationSpecialized(String functionName, Function<Geoshape, Geoshape> makeGeoshape, Function<Graph, GraphReader> readerMaker, Function<Graph, GraphWriter> writerMaker) throws Exception {
        if (makeGeoshape != null) {
            this.addGeoshape(makeGeoshape);
        }
        GraphWriter writer = writerMaker.apply((Graph)this.graph);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        writer.writeGraph((OutputStream)outputStream, (Graph)this.graph);
        JanusGraphIoTest.clearGraph(this.config);
        this.open(this.config);
        GraphReader reader = readerMaker.apply((Graph)this.graph);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        reader.readGraph((InputStream)inputStream, (Graph)this.graph);
        JanusGraphIndexTest.assertGraphOfTheGods((JanusGraph)this.graph);
        if (makeGeoshape != null) {
            this.assertGeoshape(makeGeoshape, functionName);
        }
    }

    private void addGeoshape(Function<Geoshape, Geoshape> makeGeoshape) {
        JanusGraphTransaction tx = this.graph.newTransaction();
        this.graph.traversal().E(new Object[0]).has("place").toList().forEach(e -> {
            Geoshape place = (Geoshape)e.property("place").value();
            e.property("shape", makeGeoshape.apply(place));
        });
        tx.commit();
    }

    private void assertGeoshape(Function<Geoshape, Geoshape> makeGeoshape, String functionName) {
        this.graph.traversal().E(new Object[0]).has("place").toList().forEach(e -> {
            Assertions.assertTrue((boolean)e.property("shape").isPresent(), (String)functionName);
            Geoshape place = (Geoshape)e.property("place").value();
            Geoshape expected = (Geoshape)makeGeoshape.apply(place);
            Geoshape actual = (Geoshape)e.property("shape").value();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)functionName);
        });
    }
}

