/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.junit.jupiter.api.Assertions;

public abstract class JanusGraphIterativeBenchmark
extends JanusGraphBaseTest {
    private static final Random random = new Random();

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void testDataSequential() throws Exception {
        this.loadData(200000, 2);
        this.close();
        KeyColumnValueStoreManager manager = this.openStorageManager();
        KeyColumnValueStore store = manager.openDatabase("edgestore");
        SliceQuery query = new SliceQuery(BufferUtil.zeroBuffer((int)8), BufferUtil.oneBuffer((int)8));
        query.setLimit(2);
        Stopwatch watch = Stopwatch.createStarted();
        StoreTransaction txh = manager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI));
        KeyIterator iterator = store.getKeys(query, txh);
        int numV = 0;
        while (iterator.hasNext()) {
            iterator.next();
            RecordIterator entries = iterator.getEntries();
            Assertions.assertEquals((int)2, (int)Iterators.size((Iterator)entries));
            ++numV;
        }
        iterator.close();
        txh.commit();
        System.out.println("Time taken: " + watch.elapsed(TimeUnit.MILLISECONDS));
        System.out.println("Num Vertices: " + numV);
        store.close();
        manager.close();
    }

    public void testLoadData() throws Exception {
        this.loadData(100000, 2);
    }

    public void loadData(int numVertices, int numThreads) throws Exception {
        this.makeKey("w", Integer.class);
        PropertyKey time = this.makeKey("t", Long.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("l")).sortKey(new PropertyKey[]{time}).make();
        this.finishSchema();
        int maxQueue = 1000;
        int verticesPerTask = 1000;
        int maxWeight = 10;
        int maxTime = 10000;
        ArrayBlockingQueue tasks = new ArrayBlockingQueue(1000);
        ExecutorService exe = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numVertices / 1000; ++i) {
            while (tasks.size() >= 1000) {
                Thread.sleep(1000L);
            }
            Preconditions.checkState((tasks.size() < 1000 ? 1 : 0) != 0);
            exe.submit(() -> {
                int j;
                JanusGraphTransaction tx = this.graph.newTransaction();
                JanusGraphVertex[] vs = new JanusGraphVertex[1000];
                for (j = 0; j < 1000; ++j) {
                    vs[j] = tx.addVertex(new Object[0]);
                    vs[j].property(VertexProperty.Cardinality.single, "w", (Object)random.nextInt(10), new Object[0]);
                }
                for (j = 0; j < 10000; ++j) {
                    JanusGraphEdge e = vs[random.nextInt(1000)].addEdge("l", (Vertex)vs[random.nextInt(1000)], new Object[0]);
                    e.property("t", (Object)random.nextInt(10000));
                }
                System.out.print(".");
                tx.commit();
            });
        }
        exe.shutdown();
        exe.awaitTermination(numVertices / 1000, TimeUnit.SECONDS);
        if (!exe.isTerminated()) {
            System.err.println("Could not load data in time");
        }
        System.out.println("Loaded " + numVertices + "vertices");
    }
}

