/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricFilter;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.util.CacheMetricsAction;
import org.janusgraph.diskstorage.util.MetricInstrumentedStore;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.util.stats.MetricManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="SERIAL_TESTS")
public abstract class JanusGraphOperationCountingTest
extends JanusGraphBaseTest {
    public MetricManager metric;
    public final String SYSTEM_METRICS = "org.janusgraph.sys";
    private String metricsPrefix;

    public abstract WriteConfiguration getBaseConfiguration();

    public final boolean storeUsesConsistentKeyLocker() {
        return !this.features.hasLocking();
    }

    @Override
    public WriteConfiguration getConfiguration() {
        WriteConfiguration config = this.getBaseConfiguration();
        ModifiableConfiguration modifiableConfiguration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
        modifiableConfiguration.set(GraphDatabaseConfiguration.BASIC_METRICS, (Object)true, new String[0]);
        modifiableConfiguration.set(GraphDatabaseConfiguration.METRICS_MERGE_STORES, (Object)false, new String[0]);
        modifiableConfiguration.set(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (Object)false, new String[0]);
        modifiableConfiguration.set(GraphDatabaseConfiguration.DB_CACHE, (Object)false, new String[0]);
        return config;
    }

    @Override
    public void open(WriteConfiguration config) {
        this.metric = MetricManager.INSTANCE;
        super.open(config);
    }

    private void verifyLockingOverwrite(long num) {
        if (this.storeUsesConsistentKeyLocker()) {
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)(2L * num)));
            this.verifyStoreMetrics("graphindex_lock_", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)num, (Object)"mutate", (Object)(2L * num)));
        } else {
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)num, (Object)"acquireLock", (Object)num));
        }
    }

    @Test
    public void testIdCounts() {
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.mgmt.setConsistency((JanusGraphSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        this.finishSchema();
        this.verifyStoreMetrics((String)this.getConfig().get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]), "org.janusgraph.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)3L, (Object)"getSlice", (Object)6L));
    }

    @Test
    public void testReadOperations() {
        this.testReadOperations(false);
    }

    @Test
    public void testReadOperationsWithCache() {
        this.testReadOperations(true);
    }

    public void testReadOperations(boolean cache) {
        this.metricsPrefix = "testReadOperations" + cache;
        this.resetEdgeCacheCounts();
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.mgmt.setConsistency((JanusGraphSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        this.finishSchema();
        if (cache) {
            this.clopen(JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0);
        } else {
            this.clopen(new Object[0]);
        }
        JanusGraphTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        tx.makePropertyKey("name").dataType(String.class).make();
        tx.makeEdgeLabel("knows").make();
        tx.makeVertexLabel("person").make();
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite(3L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        this.resetMetrics();
        this.metricsPrefix = "org.janusgraph.sys.schema";
        this.resetMetrics();
        for (int t = 0; t < 10; ++t) {
            tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
            Assertions.assertTrue((boolean)tx.containsRelationType("name"));
            Assertions.assertTrue((boolean)tx.containsRelationType("knows"));
            Assertions.assertTrue((boolean)tx.containsVertexLabel("person"));
            PropertyKey name = tx.getPropertyKey("name");
            EdgeLabel knows = tx.getEdgeLabel("knows");
            VertexLabel person = tx.getVertexLabel("person");
            PropertyKey uid = tx.getPropertyKey("uid");
            Assertions.assertEquals((Object)"name", (Object)name.name());
            Assertions.assertEquals((Object)"knows", (Object)knows.name());
            Assertions.assertEquals((Object)"person", (Object)person.name());
            Assertions.assertEquals((Object)"uid", (Object)uid.name());
            Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)name.cardinality());
            Assertions.assertEquals((Object)Multiplicity.MULTI, (Object)knows.multiplicity());
            Assertions.assertFalse((boolean)person.isPartitioned());
            Assertions.assertEquals(Integer.class, (Object)uid.dataType());
            InternalRelationType nameInternal = (InternalRelationType)name;
            InternalRelationType knowsInternal = (InternalRelationType)knows;
            InternalRelationType uidInternal = (InternalRelationType)uid;
            Assertions.assertNull((Object)nameInternal.getBaseType());
            Assertions.assertNull((Object)knowsInternal.getBaseType());
            IndexType index = (IndexType)Iterables.getOnlyElement((Iterable)uidInternal.getKeyIndexes());
            Assertions.assertEquals((int)1, (int)index.getFieldKeys().length);
            Assertions.assertEquals((Object)ElementCategory.VERTEX, (Object)index.getElement());
            Assertions.assertEquals((Object)ConsistencyModifier.LOCK, (Object)((CompositeIndexType)index).getConsistencyModifier());
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)uidInternal.getRelationIndexes()));
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)nameInternal.getRelationIndexes()));
            Assertions.assertEquals((Object)nameInternal, (Object)Iterables.getOnlyElement((Iterable)nameInternal.getRelationIndexes()));
            Assertions.assertEquals((Object)knowsInternal, (Object)Iterables.getOnlyElement((Iterable)knowsInternal.getRelationIndexes()));
            Assertions.assertEquals((int)0, (int)((InternalVertexLabel)person).getTTL());
            tx.commit();
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)19L));
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L, (Object)"acquireLock", (Object)0L));
        }
        this.metricsPrefix = "add" + cache;
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        JanusGraphVertex v = tx.addVertex(new Object[0]);
        JanusGraphVertex u = tx.addVertex("person");
        v.property(VertexProperty.Cardinality.single, "uid", (Object)1, new Object[0]);
        u.property(VertexProperty.Cardinality.single, "name", (Object)"juju", new Object[0]);
        JanusGraphEdge e = v.addEdge("knows", (Vertex)u, new Object[0]);
        e.property("name", (Object)"edge");
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite(1L);
        for (int i = 1; i <= 30; ++i) {
            this.metricsPrefix = "op" + i + cache;
            tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
            v = (JanusGraphVertex)JanusGraphOperationCountingTest.getOnlyElement(tx.query().has("uid", (Object)1).vertices());
            Assertions.assertEquals((int)1, (int)((Integer)v.value("uid")));
            u = (JanusGraphVertex)JanusGraphOperationCountingTest.getOnlyElement(v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).vertices());
            e = (Edge)JanusGraphOperationCountingTest.getOnlyElement(u.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((Object)"juju", (Object)u.value("name"));
            Assertions.assertEquals((Object)"edge", (Object)e.value("name"));
            tx.commit();
            if (!cache) {
                this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
                this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
                continue;
            }
            if (i <= 20) continue;
            this.verifyStoreMetrics("edgestore");
            this.verifyStoreMetrics("graphindex");
        }
    }

    @Test
    public void testSettingProperty() {
        this.metricsPrefix = "testSettingProperty";
        this.mgmt.makePropertyKey("foo").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.clopen(JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property("foo", (Object)"bar");
        this.tx.commit();
        JanusGraphTransaction tx = this.graph.buildTransaction().checkExternalVertexExistence(false).groupName(this.metricsPrefix).start();
        v = tx.getVertex(v.longId());
        v.property("foo", (Object)"bus");
        long numLookupPropertyConstraints = 1L;
        tx.commit();
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)numLookupPropertyConstraints));
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        tx = this.graph.buildTransaction().checkExternalVertexExistence(false).groupName(this.metricsPrefix).start();
        v = tx.getVertex(v.longId());
        v.property("foo", (Object)"band");
        Assertions.assertEquals((Object)"band", (Object)v.property("foo").value());
        Assertions.assertEquals((int)1, (int)Iterators.size((Iterator)v.properties(new String[]{"foo"})));
        Assertions.assertEquals((int)1, (int)Iterators.size((Iterator)v.properties(new String[0])));
        tx.commit();
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)(2L + ++numLookupPropertyConstraints)));
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)2L));
        this.verifyStoreMetrics((String)this.getConfig().get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]));
    }

    @Test
    public void testKCVSAccess1() {
        this.metricsPrefix = "testKCVSAccess1";
        JanusGraphTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        JanusGraphVertex v = tx.addVertex(new Object[]{"age", 25, "name", "john"});
        JanusGraphVertex u = tx.addVertex(new Object[]{"age", 35, "name", "mary"});
        v.addEdge("knows", (Vertex)u, new Object[0]);
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite(3L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)(1L + (long)(this.features.hasTxIsolation() ? 0 : 1))));
        this.verifyTypeCacheMetrics(3, 0);
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = JanusGraphOperationCountingTest.getV((Transaction)tx, v);
        JanusGraphAssert.assertCount(2, v.properties(new String[0]));
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L));
        this.verifyTypeCacheMetrics(3, 4);
        tx.commit();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = JanusGraphOperationCountingTest.getV((Transaction)tx, v);
        JanusGraphAssert.assertCount(2, v.properties(new String[0]));
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
        this.verifyTypeCacheMetrics(3, 4);
        tx.commit();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = JanusGraphOperationCountingTest.getV((Transaction)tx, v);
        Assertions.assertNotNull((Object)v.value("age"));
        Assertions.assertNotNull((Object)v.value("name"));
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)7L));
        this.verifyTypeCacheMetrics(5, 8);
        tx.commit();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = JanusGraphOperationCountingTest.getV((Transaction)tx, v);
        Assertions.assertNotNull((Object)v.value("age"));
        Assertions.assertNotNull((Object)v.value("name"));
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).edges());
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)11L));
        this.verifyTypeCacheMetrics(5, 10);
        tx.commit();
        this.verifyLockingOverwrite(3L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)(1L + (long)(this.features.hasTxIsolation() ? 0 : 1))));
    }

    @Test
    public void checkPropertyLockingAndIndex() {
        PropertyKey uid = this.makeKey("uid", String.class);
        JanusGraphIndex index = this.mgmt.buildIndex("uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        this.mgmt.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.finishSchema();
        this.metricsPrefix = "checkPropertyLockingAndIndex";
        JanusGraphTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        JanusGraphVertex v = tx.addVertex(new Object[]{"uid", "v1", "age", 25, "name", "john"});
        Assertions.assertEquals((Object)25, (Object)v.property("age").value());
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite(1L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        this.resetMetrics();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").vertices());
        Assertions.assertEquals((Object)25, (Object)v.property("age").value());
        tx.commit();
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
        this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
        this.verifyStoreMetrics("storeManager");
    }

    @Test
    public void checkFastPropertyTrue() {
        this.checkFastProperty(true);
    }

    @Test
    public void checkFastPropertyFalse() {
        this.checkFastProperty(false);
    }

    public void checkFastProperty(boolean fastProperty) {
        this.makeKey("uid", String.class);
        this.makeKey("name", String.class);
        this.makeKey("age", String.class);
        this.finishSchema();
        this.clopen(JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), fastProperty);
        this.metricsPrefix = "checkFastProperty" + fastProperty;
        JanusGraphTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        JanusGraphVertex v = tx.addVertex(new Object[]{"uid", "v1", "age", 25, "name", "john"});
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = JanusGraphOperationCountingTest.getV((Transaction)tx, v);
        Assertions.assertEquals((Object)"v1", (Object)v.property("uid").value());
        Assertions.assertEquals((Object)"25", (Object)v.property("age").value());
        Assertions.assertEquals((Object)"john", (Object)v.property("name").value());
        tx.commit();
        if (fastProperty) {
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L));
        } else {
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
        }
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
    }

    public void verifyStoreMetrics(String storeName) {
        this.verifyStoreMetrics(storeName, new HashMap<String, Long>(0));
    }

    public void verifyStoreMetrics(String storeName, Map<String, Long> operationCounts) {
        this.verifyStoreMetrics(storeName, this.metricsPrefix, operationCounts);
    }

    public void verifyStoreMetrics(String storeName, String prefix, Map<String, Long> operationCounts) {
        for (String operation : MetricInstrumentedStore.OPERATION_NAMES) {
            Long count = operationCounts.get(operation);
            if (count == null) {
                count = 0L;
            }
            Assertions.assertEquals((long)count, (long)this.metric.getCounter(prefix, new String[]{storeName, operation, "calls"}).getCount(), (String)Joiner.on((String)".").join((Object)prefix, (Object)storeName, new Object[]{operation, "calls"}));
        }
    }

    public void verifyTypeCacheMetrics(int nameMisses, int relationMisses) {
        this.verifyTypeCacheMetrics(this.metricsPrefix, nameMisses, relationMisses);
    }

    public void verifyTypeCacheMetrics(String prefix, int nameMisses, int relationMisses) {
        Assertions.assertEquals((long)nameMisses, (long)this.metric.getCounter("org.janusgraph.sys", new String[]{"schemacache", "name", CacheMetricsAction.MISS.getName()}).getCount(), (String)"On type cache name misses");
        Assertions.assertTrue(((long)nameMisses <= this.metric.getCounter("org.janusgraph.sys", new String[]{"schemacache", "name", CacheMetricsAction.RETRIEVAL.getName()}).getCount() ? 1 : 0) != 0);
        Assertions.assertEquals((long)relationMisses, (long)this.metric.getCounter("org.janusgraph.sys", new String[]{"schemacache", "relations", CacheMetricsAction.MISS.getName()}).getCount(), (String)"On type cache relation misses");
        Assertions.assertTrue(((long)relationMisses <= this.metric.getCounter("org.janusgraph.sys", new String[]{"schemacache", "relations", CacheMetricsAction.RETRIEVAL.getName()}).getCount() ? 1 : 0) != 0);
    }

    public void printAllMetrics(String prefix) {
        ArrayList<Object> storeNames = new ArrayList<Object>();
        storeNames.add("edgestore");
        storeNames.add("graphindex");
        storeNames.add(this.getConfig().get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]));
        storeNames.add("storeManager");
        if (this.storeUsesConsistentKeyLocker()) {
            storeNames.add("edgestore_lock_");
            storeNames.add("graphindex_lock_");
        }
        for (String string : storeNames) {
            System.out.println("######## Store: " + string + " (" + prefix + ")");
            for (String operation : MetricInstrumentedStore.OPERATION_NAMES) {
                System.out.println("-- Operation: " + operation);
                System.out.print("\t");
                System.out.println(this.metric.getCounter(prefix, new String[]{string, operation, "calls"}).getCount());
                System.out.print("\t");
                System.out.println(this.metric.getTimer(prefix, new String[]{string, operation, "time"}).getMeanRate());
                if (!operation.equals("getSlice")) continue;
                System.out.print("\t");
                System.out.println(this.metric.getCounter(prefix, new String[]{string, operation, "entries-returned"}).getCount());
            }
        }
    }

    @Test
    public void testCacheConcurrency() throws InterruptedException {
        this.metricsPrefix = "tCC";
        Object[] newConfig = new Object[]{JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_SIZE, new String[0]), 0.25, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]), true, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]), false, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0]), this.metricsPrefix, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true};
        this.clopen(newConfig);
        String prop = "someProp";
        this.makeKey("someProp", Integer.class);
        this.finishSchema();
        int numV = 100;
        long[] vertexIds = new long[100];
        for (int i = 0; i < 100; ++i) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{"someProp", 0});
            this.graph.tx().commit();
            vertexIds[i] = JanusGraphOperationCountingTest.getId((Element)v);
        }
        this.clopen(newConfig);
        this.resetEdgeCacheCounts();
        AtomicBoolean[] precommit = new AtomicBoolean[100];
        AtomicBoolean[] postcommit = new AtomicBoolean[100];
        for (int i = 0; i < 100; ++i) {
            precommit[i] = new AtomicBoolean(false);
            postcommit[i] = new AtomicBoolean(false);
        }
        AtomicInteger lookups = new AtomicInteger(0);
        Random random = new Random();
        int updateSleepTime = 40;
        int readSleepTime = 2;
        int numReads = Math.round(4000.0f);
        Thread reader = new Thread(() -> {
            for (int reads = 0; reads < numReads; ++reads) {
                int pos = random.nextInt(vertexIds.length);
                long vid = vertexIds[pos];
                JanusGraphVertex v = JanusGraphOperationCountingTest.getV((Transaction)this.graph, vid);
                Assertions.assertNotNull((Object)v);
                boolean postCommit = postcommit[pos].get();
                Integer value = (Integer)v.value("someProp");
                lookups.incrementAndGet();
                Assertions.assertNotNull((Object)value, (String)("On pos [" + pos + "]"));
                if (!precommit[pos].get()) {
                    Assertions.assertEquals((int)0, (int)value);
                } else if (postCommit) {
                    Assertions.assertEquals((int)1, (int)value);
                }
                this.graph.tx().commit();
                try {
                    Thread.sleep(2L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        reader.start();
        Thread updater = new Thread(() -> {
            for (int i = 0; i < 100; ++i) {
                try {
                    JanusGraphVertex v = JanusGraphOperationCountingTest.getV((Transaction)this.graph, vertexIds[i]);
                    v.property(VertexProperty.Cardinality.single, "someProp", (Object)1, new Object[0]);
                    precommit[i].set(true);
                    this.graph.tx().commit();
                    postcommit[i].set(true);
                    Thread.sleep(40L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unexpected interruption", e);
                }
            }
        });
        updater.start();
        updater.join();
        reader.join();
        System.out.println("Retrievals: " + this.getEdgeCacheRetrievals());
        System.out.println("Hits: " + (this.getEdgeCacheRetrievals() - this.getEdgeCacheMisses()));
        System.out.println("Misses: " + this.getEdgeCacheMisses());
        Assertions.assertEquals((int)numReads, (int)lookups.get());
        int numLookupPropertyConstraints = 100;
        Assertions.assertEquals((long)(2 * numReads + 100 + 100), (long)this.getEdgeCacheRetrievals());
        int minMisses = 200;
        Assertions.assertTrue(((long)minMisses <= this.getEdgeCacheMisses() && (long)(4 * minMisses) >= this.getEdgeCacheMisses() ? 1 : 0) != 0, (String)("Min misses [" + minMisses + "] vs actual [" + this.getEdgeCacheMisses() + "]"));
    }

    private long getEdgeCacheRetrievals() {
        return this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.RETRIEVAL.getName()}).getCount();
    }

    private long getEdgeCacheMisses() {
        return this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.MISS.getName()}).getCount();
    }

    private void resetEdgeCacheCounts() {
        Counter counter = this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.RETRIEVAL.getName()});
        counter.dec(counter.getCount());
        counter = this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.MISS.getName()});
        counter.dec(counter.getCount());
    }

    protected void resetMetrics() {
        MetricManager.INSTANCE.getRegistry().removeMatching(MetricFilter.ALL);
    }

    @Test
    public void testCacheSpeedup() {
        Object[] newConfig = new Object[]{JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0};
        this.clopen(newConfig);
        int numV = 1000;
        JanusGraphVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{"name", "v" + i});
            if (previous != null) {
                v.addEdge("knows", (Vertex)previous, new Object[0]);
            }
            previous = v;
        }
        this.graph.tx().commit();
        long vertexId = JanusGraphOperationCountingTest.getId(previous);
        JanusGraphAssert.assertCount(numV, this.graph.query().vertices());
        this.clopen(newConfig);
        double timeColdGlobal = 0.0;
        double timeWarmGlobal = 0.0;
        double timeHotGlobal = 0.0;
        int outerRepeat = 20;
        int measurements = 10;
        int innerRepeat = 2;
        for (int c = 0; c < outerRepeat; ++c) {
            double timeCold = this.testAllVertices(vertexId, numV);
            double timeWarm = 0.0;
            double timeHot = 0.0;
            for (int i = 0; i < innerRepeat; ++i) {
                this.graph.tx().commit();
                timeWarm += this.testAllVertices(vertexId, numV);
                for (int j = 0; j < innerRepeat; ++j) {
                    timeHot += this.testAllVertices(vertexId, numV);
                }
            }
            timeWarm /= (double)innerRepeat;
            timeHot /= (double)(innerRepeat * innerRepeat);
            if (c >= outerRepeat - measurements) {
                timeColdGlobal += timeCold;
                timeWarmGlobal += timeWarm;
                timeHotGlobal += timeHot;
            }
            this.clopen(newConfig);
        }
        System.out.println(JanusGraphOperationCountingTest.round(timeColdGlobal /= (double)measurements) + "\t" + JanusGraphOperationCountingTest.round(timeWarmGlobal /= (double)measurements) + "\t" + JanusGraphOperationCountingTest.round(timeHotGlobal /= (double)measurements));
        Assertions.assertTrue((timeColdGlobal > timeWarmGlobal * 2.0 ? 1 : 0) != 0, (String)(timeColdGlobal + " vs " + timeWarmGlobal));
    }

    private double testAllVertices(long vid, int numV) {
        long start = System.nanoTime();
        JanusGraphVertex v = JanusGraphOperationCountingTest.getV((Transaction)this.graph, vid);
        for (int i = 1; i < numV; ++i) {
            v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).vertices());
        }
        return (double)(System.nanoTime() - start) / 1000000.0;
    }
}

