/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.StandardIndexProvider;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.query.JanusGraphPredicate;

public class TestMockIndexProvider
implements IndexProvider {
    public static final ConfigOption<Boolean> INDEX_MOCK_FAILADD = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "fail-adds", "Sets the index provider to reject adding documents. FOR TESTING ONLY", ConfigOption.Type.LOCAL, (Object)false).hide();
    public static final ConfigOption<String> INDEX_BACKEND_PROXY = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "proxy-for", "Define the indexing backed to use for index support behind the mock proxy", ConfigOption.Type.GLOBAL, GraphDatabaseConfiguration.INDEX_BACKEND.getDefaultValue()).hide();
    private final IndexProvider index;
    private final boolean failAdds;

    public TestMockIndexProvider(Configuration config) {
        this.index = (IndexProvider)Backend.getImplementationClass((Configuration)config, (String)((String)config.get(INDEX_BACKEND_PROXY, new String[0])), (Map)StandardIndexProvider.getAllProviderClasses());
        this.failAdds = (Boolean)config.get(INDEX_MOCK_FAILADD, new String[0]);
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        this.index.register(store, key, information, tx);
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        if (this.failAdds) {
            throw new TemporaryBackendException("Blocked mutation");
        }
        this.index.mutate(mutations, information, tx);
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        if (this.failAdds) {
            throw new TemporaryBackendException("Blocked mutation");
        }
        this.index.restore(documents, information, tx);
    }

    public Stream<String> query(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.index.query(query, information, tx);
    }

    public Stream<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.index.query(query, information, tx);
    }

    public Long totals(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.index.totals(query, information, tx);
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return this.index.beginTransaction(config);
    }

    public void close() throws BackendException {
        this.index.close();
    }

    public void clearStorage() throws BackendException {
        this.index.clearStorage();
    }

    public boolean exists() throws BackendException {
        return this.index.exists();
    }

    public boolean supports(KeyInformation information, JanusGraphPredicate janusgraphPredicate) {
        return this.index.supports(information, janusgraphPredicate);
    }

    public boolean supports(KeyInformation information) {
        return this.index.supports(information);
    }

    public String mapKey2Field(String key, KeyInformation information) {
        return this.index.mapKey2Field(key, information);
    }

    public IndexFeatures getFeatures() {
        return this.index.getFeatures();
    }
}

