/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.olap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ShortestPath;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphComputer;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.Transaction;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.olap.QueryContainer;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.olap.computer.FulgoraGraphComputer;
import org.janusgraph.graphdb.olap.job.GhostVertexRemover;
import org.janusgraph.olap.PageRankMapReduce;
import org.janusgraph.olap.PageRankVertexProgram;
import org.janusgraph.olap.ShortestDistanceMapReduce;
import org.janusgraph.olap.ShortestDistanceVertexProgram;
import org.janusgraph.testutil.JanusGraphAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OLAPTest
extends JanusGraphBaseTest {
    private static final Random random = new Random();
    private static final Logger log = LoggerFactory.getLogger(OLAPTest.class);

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
    }

    private ScanMetrics executeScanJob(VertexScanJob job) throws Exception {
        return this.executeScanJob(VertexJobConverter.convert((JanusGraph)this.graph, (VertexScanJob)job));
    }

    private ScanMetrics executeScanJob(ScanJob job) throws Exception {
        return (ScanMetrics)this.graph.getBackend().buildEdgeScanJob().setNumProcessingThreads(2).setWorkBlockSize(100).setJob(job).execute().get();
    }

    private int generateRandomGraph(int numV) {
        int i;
        this.mgmt.makePropertyKey("uid").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makePropertyKey("values").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("numvals").dataType(Integer.class).make();
        this.finishSchema();
        int numE = 0;
        JanusGraphVertex[] vs = new JanusGraphVertex[numV];
        for (i = 0; i < numV; ++i) {
            vs[i] = this.tx.addVertex(new Object[]{"uid", i + 1});
            int numberOfValues = random.nextInt(5) + 1;
            vs[i].property(VertexProperty.Cardinality.single, "numvals", (Object)numberOfValues, new Object[0]);
            for (int j = 0; j < numberOfValues; ++j) {
                vs[i].property("values", (Object)random.nextInt(100));
            }
        }
        for (i = 0; i < numV; ++i) {
            int edges = i + 1;
            JanusGraphVertex v = vs[i];
            for (int j = 0; j < edges; ++j) {
                JanusGraphVertex u = vs[random.nextInt(numV)];
                v.addEdge("knows", (Vertex)u, new Object[0]);
                ++numE;
            }
        }
        Assertions.assertEquals((int)(numV * (numV + 1)), (int)(numE * 2));
        return numE;
    }

    @Test
    public void scannerShouldSeeAllVertices() throws Exception {
        GraphTraversalSource g = this.graph.traversal();
        Vertex v1 = (Vertex)g.addV().next();
        Vertex v2 = (Vertex)g.addV().next();
        g.V(new Object[]{v1}).addE("connect").to(v2).iterate();
        g.addV().addV().addV().property((Object)"p", (Object)"v", new Object[0]).iterate();
        g.tx().commit();
        final AtomicInteger vertexNum = new AtomicInteger();
        this.executeScanJob(new VertexScanJob(){

            public void process(JanusGraphVertex vertex, ScanMetrics metrics) {
                vertexNum.incrementAndGet();
            }

            public void getQueries(QueryContainer queries) {
                queries.addQuery().properties();
                queries.addQuery().edges();
            }

            public VertexScanJob clone() {
                return this;
            }
        });
        Assertions.assertEquals((Long)((Long)g.V(new Object[0]).count().next()), (long)vertexNum.get());
    }

    @Test
    public void testVertexScan() throws Exception {
        int numV = 100;
        int numE = this.generateRandomGraph(numV);
        String DEGREE_COUNT = "degree";
        String VERTEX_COUNT = "numV";
        this.clopen(new Object[0]);
        ScanMetrics result1 = this.executeScanJob(new VertexScanJob(){

            public void process(JanusGraphVertex vertex, ScanMetrics metrics) {
                long outDegree = vertex.query().labels(new String[]{"knows"}).direction(Direction.OUT).edgeCount();
                Assertions.assertEquals((long)0L, (long)vertex.query().labels(new String[]{"knows"}).direction(Direction.IN).edgeCount());
                Assertions.assertEquals((long)1L, (long)vertex.query().labels(new String[]{"uid"}).propertyCount());
                Assertions.assertTrue(((Integer)vertex.property("uid").orElse((Object)0) > 0 ? 1 : 0) != 0);
                metrics.incrementCustom("degree", outDegree);
                metrics.incrementCustom("numV");
            }

            public void getQueries(QueryContainer queries) {
                queries.addQuery().labels(new String[]{"knows"}).direction(Direction.OUT).edges();
                queries.addQuery().keys(new String[]{"uid"}).properties();
            }

            public VertexScanJob clone() {
                return this;
            }
        });
        Assertions.assertEquals((long)numV, (long)result1.getCustom("numV"));
        Assertions.assertEquals((long)numE, (long)result1.getCustom("degree"));
        ScanMetrics result2 = this.executeScanJob(new VertexScanJob(){

            public void process(JanusGraphVertex vertex, ScanMetrics metrics) {
                metrics.incrementCustom("numV");
                Assertions.assertEquals((long)1L, (long)vertex.query().labels(new String[]{"numvals"}).propertyCount());
                int numvals = (Integer)vertex.value("numvals");
                Assertions.assertEquals((long)numvals, (long)vertex.query().labels(new String[]{"values"}).propertyCount());
            }

            public void getQueries(QueryContainer queries) {
                queries.addQuery().keys(new String[]{"values"}).properties();
                queries.addQuery().keys(new String[]{"numvals"}).properties();
            }

            public VertexScanJob clone() {
                return this;
            }
        });
        Assertions.assertEquals((long)numV, (long)result2.getCustom("numV"));
    }

    @Test
    public void removeGhostVertices() throws Exception {
        JanusGraphVertex v1 = this.tx.addVertex("person");
        v1.property("name", (Object)"stephen");
        JanusGraphVertex v2 = this.tx.addVertex("person");
        v1.property("name", (Object)"marko");
        JanusGraphVertex v3 = this.tx.addVertex("person");
        v1.property("name", (Object)"dan");
        v2.addEdge("knows", (Vertex)v3, new Object[0]);
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.newTx();
        long v3id = OLAPTest.getId((Element)v3);
        long v1id = OLAPTest.getId((Element)v1);
        Assertions.assertTrue((v3id > 0L ? 1 : 0) != 0);
        v3 = OLAPTest.getV((Transaction)this.tx, v3id);
        Assertions.assertNotNull((Object)v3);
        v3.remove();
        this.tx.commit();
        JanusGraphTransaction xx = this.graph.buildTransaction().checkExternalVertexExistence(false).start();
        v3 = OLAPTest.getV((Transaction)xx, v3id);
        Assertions.assertNotNull((Object)v3);
        v1 = OLAPTest.getV((Transaction)xx, v1id);
        Assertions.assertNotNull((Object)v1);
        v3.property("name", (Object)"deleted");
        v3.addEdge("knows", (Vertex)v1, new Object[0]);
        xx.commit();
        this.newTx();
        Assertions.assertNull((Object)OLAPTest.getV((Transaction)this.tx, v3id));
        v1 = OLAPTest.getV((Transaction)this.tx, v1id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertEquals((long)v3id, (long)((JanusGraphVertex)v1.query().direction(Direction.IN).labels(new String[]{"knows"}).vertices().iterator().next()).longId());
        this.tx.commit();
        this.mgmt.commit();
        ScanMetrics result = this.executeScanJob((ScanJob)new GhostVertexRemover((JanusGraph)this.graph));
        Assertions.assertEquals((long)1L, (long)result.getCustom("removed-vertices"));
        Assertions.assertEquals((long)2L, (long)result.getCustom("removed-relations"));
        Assertions.assertEquals((long)0L, (long)result.getCustom("skipped-ghosts"));
        result = this.executeScanJob((ScanJob)new GhostVertexRemover((JanusGraph)this.graph));
        Assertions.assertEquals((long)0L, (long)result.getCustom("removed-vertices"));
        Assertions.assertEquals((long)0L, (long)result.getCustom("removed-relations"));
        Assertions.assertEquals((long)0L, (long)result.getCustom("skipped-ghosts"));
    }

    @Test
    public void testBasicComputeJob() {
        GraphTraversalSource g = this.graph.traversal().withComputer(FulgoraGraphComputer.class);
        System.out.println(g.V(new Object[0]).count().next());
    }

    @Test
    public void degreeCounting() throws Exception {
        int numV = 200;
        int numE = this.generateRandomGraph(numV);
        this.clopen(new Object[0]);
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(JanusGraphComputer.ResultMode.NONE);
        computer.workers(4);
        computer.program((VertexProgram)new DegreeCounter());
        computer.mapReduce((MapReduce)new DegreeMapper());
        ComputerResult result = (ComputerResult)computer.submit().get();
        System.out.println("Execution time (ms) [" + numV + "|" + numE + "]: " + result.memory().getRuntime());
        Assertions.assertTrue((boolean)result.memory().exists("degrees"));
        Map degrees = (Map)result.memory().get("degrees");
        Assertions.assertNotNull((Object)degrees);
        Assertions.assertEquals((int)numV, (int)degrees.size());
        int totalCount = 0;
        for (Map.Entry entry : degrees.entrySet()) {
            int degree = (Integer)entry.getValue();
            JanusGraphVertex v = OLAPTest.getV((Transaction)this.tx, entry.getKey());
            int count = (Integer)v.value("uid");
            Assertions.assertEquals((int)count, (int)degree);
            totalCount += degree;
        }
        Assertions.assertEquals((int)(numV * (numV + 1) / 2), (int)totalCount);
        Assertions.assertEquals((int)1, (int)result.memory().getIteration());
    }

    @Test
    public void vertexProgramExceptionPropagatesToCaller() throws InterruptedException {
        int numV = 100;
        this.generateRandomGraph(numV);
        this.clopen(new Object[0]);
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(JanusGraphComputer.ResultMode.NONE);
        computer.workers(1);
        computer.program((VertexProgram)new ExceptionProgram());
        try {
            computer.submit().get();
            Assertions.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void degreeCountingDistance() throws Exception {
        int numV = 100;
        int numE = this.generateRandomGraph(numV);
        this.clopen(new Object[0]);
        for (JanusGraphComputer.ResultMode mode : JanusGraphComputer.ResultMode.values()) {
            FulgoraGraphComputer computer = this.graph.compute();
            computer.resultMode(mode);
            computer.workers(1);
            computer.program((VertexProgram)new DegreeCounter(2));
            ComputerResult result = (ComputerResult)computer.submit().get();
            System.out.println("Execution time (ms) [" + numV + "|" + numE + "]: " + result.memory().getRuntime());
            Assertions.assertEquals((int)2, (int)result.memory().getIteration());
            Transaction gview = null;
            switch (mode) {
                case LOCALTX: {
                    gview = (Transaction)result.graph();
                    break;
                }
                case PERSIST: {
                    this.newTx();
                    gview = this.tx;
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new AssertionError(mode);
                }
            }
            if (gview == null) continue;
            for (JanusGraphVertex v : gview.query().vertices()) {
                long degree2 = ((Integer)v.value("degree")).longValue();
                long actualDegree2 = 0L;
                for (Object w : v.query().direction(Direction.OUT).vertices()) {
                    actualDegree2 += (long)Iterables.size((Iterable)((JanusGraphVertex)w).query().direction(Direction.OUT).vertices());
                }
                Assertions.assertEquals((long)actualDegree2, (long)degree2);
            }
            if (mode != JanusGraphComputer.ResultMode.LOCALTX) continue;
            Assertions.assertTrue((boolean)(gview instanceof JanusGraphTransaction));
            ((JanusGraphTransaction)gview).rollback();
        }
    }

    private void expand(Vertex v, int distance, int diameter, int branch) {
        v.property(VertexProperty.Cardinality.single, "distance", (Object)distance, new Object[0]);
        if (distance < diameter) {
            for (int i = 0; i < branch; ++i) {
                JanusGraphVertex u = this.tx.addVertex(new Object[0]);
                u.addEdge("likes", v, new Object[0]);
                log.debug("likes {}->{}", u.id(), v.id());
                this.expand((Vertex)u, distance + 1, diameter, branch);
            }
        }
    }

    @Test
    public void testPageRank() throws ExecutionException, InterruptedException {
        this.mgmt.makePropertyKey("distance").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makeEdgeLabel("likes").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        int branch = 6;
        int diameter = 5;
        double alpha = 0.85;
        int numV = (int)((Math.pow(6.0, 6.0) - 1.0) / 5.0);
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        this.expand((Vertex)v, 0, 5, 6);
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        log.debug("PR test numV: {}", (Object)numV);
        this.newTx();
        double[] correctPR = new double[6];
        for (int i = 5; i >= 0; --i) {
            double pr = 0.15000000000000002 / (double)numV;
            if (i < 5) {
                pr += 5.1 * correctPR[i + 1];
            }
            log.debug("diameter={} pr={}", (Object)5, (Object)pr);
            correctPR[i] = pr;
        }
        double correctPRSum = 0.0;
        for (JanusGraphVertex janusGraphVertex : this.tx.query().vertices()) {
            correctPRSum += correctPR[(Integer)janusGraphVertex.value("distance")];
        }
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(JanusGraphComputer.ResultMode.NONE);
        computer.workers(4);
        computer.program(PageRankVertexProgram.build().iterations(10).vertexCount(numV).dampingFactor(0.85).create((Graph)this.graph));
        computer.mapReduce((MapReduce)PageRankMapReduce.build().create());
        ComputerResult result = (ComputerResult)computer.submit().get();
        Iterator ranks = (Iterator)result.memory().get("pageRank");
        Assertions.assertNotNull((Object)ranks);
        int vertexCounter = 0;
        double computedPRSum = 0.0;
        correctPRSum = 0.0;
        HashSet<Long> vertexIDs = new HashSet<Long>(numV);
        while (ranks.hasNext()) {
            KeyValue rank = (KeyValue)ranks.next();
            Long vertexID = (Long)rank.getKey();
            Double computedPR = (Double)rank.getValue();
            Assertions.assertNotNull((Object)vertexID);
            Assertions.assertNotNull((Object)computedPR);
            JanusGraphVertex u = OLAPTest.getV((Transaction)this.tx, vertexID);
            int distance = (Integer)u.value("distance");
            ++vertexCounter;
            computedPRSum += computedPR.doubleValue();
            correctPRSum += correctPR[distance];
            Assertions.assertFalse((boolean)vertexIDs.contains(vertexID));
            vertexIDs.add(vertexID);
            log.debug("vertexID={} computedPR={}", (Object)vertexID, (Object)computedPR);
        }
        Assertions.assertEquals((int)numV, (int)vertexCounter);
        Assertions.assertEquals((double)correctPRSum, (double)computedPRSum, (double)0.001);
    }

    @Test
    public void testShortestDistance() throws Exception {
        PropertyKey distance = this.mgmt.makePropertyKey("distance").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{distance}).multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        int maxDepth = 16;
        int maxBranch = 5;
        JanusGraphVertex vertex = this.tx.addVertex(new Object[0]);
        int numV = this.growVertex((Vertex)vertex, 0, maxDepth, maxBranch);
        int numE = numV - 1;
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        log.debug("seed inE count: {}", (Object)vertex.query().direction(Direction.IN).edgeCount());
        log.debug("seed outE count: {}", (Object)vertex.query().direction(Direction.OUT).edgeCount());
        this.clopen(new Object[0]);
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(JanusGraphComputer.ResultMode.NONE);
        computer.workers(4);
        computer.program(ShortestDistanceVertexProgram.build().seed((Long)vertex.id()).maxDepth(maxDepth + 4).create((Graph)this.graph));
        computer.mapReduce((MapReduce)ShortestDistanceMapReduce.build().create());
        ComputerResult result = (ComputerResult)computer.submit().get();
        Iterator distances = (Iterator)result.memory().get("shortestDistance");
        int vertexCount = 0;
        while (distances.hasNext()) {
            KeyValue kv = (KeyValue)distances.next();
            long dist = (Long)kv.getValue();
            Assertions.assertTrue((dist >= 0L && dist < Integer.MAX_VALUE ? 1 : 0) != 0, (String)("Invalid distance: " + dist));
            JanusGraphVertex v = OLAPTest.getV((Transaction)this.tx, kv.getKey());
            Assertions.assertEquals((long)((Integer)v.value("distance")).intValue(), (long)dist);
            ++vertexCount;
        }
        Assertions.assertEquals((int)numV, (int)vertexCount);
        Assertions.assertTrue((0 < vertexCount ? 1 : 0) != 0);
    }

    private int growVertex(Vertex vertex, int depth, int maxDepth, int maxBranch) {
        vertex.property(VertexProperty.Cardinality.single, "distance", (Object)depth, new Object[0]);
        int total = 1;
        if (depth >= maxDepth) {
            return total;
        }
        for (int i = 0; i < random.nextInt(maxBranch) + 1; ++i) {
            int dist = random.nextInt(3) + 1;
            JanusGraphVertex n = this.tx.addVertex(new Object[0]);
            n.addEdge("connect", vertex, new Object[]{"distance", dist});
            total += this.growVertex((Vertex)n, depth + dist, maxDepth, maxBranch);
        }
        return total;
    }

    @Test
    public void testShortestPath() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex v1 = (Vertex)g.addV().next();
        Vertex v2 = (Vertex)g.addV().next();
        g.V(new Object[]{v1}).addE("connect").to(v2).iterate();
        g.tx().commit();
        g = this.graph.traversal().withComputer();
        List paths = g.V(new Object[]{v1}).shortestPath().with(ShortestPath.target, (Object)__.is((Object)v2)).toList();
        JanusGraphAssert.assertCount(1, paths);
        Assertions.assertEquals((int)2, (int)((Path)paths.get(0)).size());
    }

    @Test
    public void testConnectedComponent() {
        this.createComponentWithThreeVertices();
        this.newTx();
        GraphTraversalSource g = this.graph.traversal();
        Vertex isolatedVertex = (Vertex)g.addV().property((Object)"id", (Object)-1, new Object[0]).next();
        g.tx().commit();
        g = this.graph.traversal().withComputer(FulgoraGraphComputer.class);
        GraphTraversal traversal = g.V(new Object[0]).connectedComponent().project("id", new String[]{"component"}).by("id").by("gremlin.connectedComponentVertexProgram.component");
        boolean foundIsolatedVertex = false;
        ArrayList<String> nonIsolatedComponents = new ArrayList<String>();
        while (traversal.hasNext()) {
            Map m = (Map)traversal.next();
            if (m.get("component").equals(isolatedVertex.id().toString())) {
                foundIsolatedVertex = true;
                continue;
            }
            nonIsolatedComponents.add((String)m.get("component"));
        }
        Assertions.assertTrue((boolean)foundIsolatedVertex);
        Assertions.assertEquals((int)3, (int)nonIsolatedComponents.size());
        Assertions.assertEquals(nonIsolatedComponents.get(0), nonIsolatedComponents.get(1));
        Assertions.assertEquals(nonIsolatedComponents.get(1), nonIsolatedComponents.get(2));
    }

    private void createComponentWithThreeVertices() {
        this.mgmt.makePropertyKey("id").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").make();
        this.finishSchema();
        GraphTraversalSource g = this.graph.traversal();
        Vertex v1 = (Vertex)g.addV().property((Object)"id", (Object)0, new Object[0]).next();
        Vertex v2 = (Vertex)g.addV().property((Object)"id", (Object)1, new Object[0]).next();
        Vertex v3 = (Vertex)g.addV().property((Object)"id", (Object)2, new Object[0]).next();
        g.V(new Object[]{v1}).addE("knows").to(v2).iterate();
        g.V(new Object[]{v2}).addE("knows").to(v3).iterate();
        this.tx.commit();
    }

    public static class Degree {
        public int in;
        public int out;
        public int both;
        public int prop;

        public Degree(int in, int out, int prop) {
            this.in = in;
            this.out = out;
            this.both = in + out;
            this.prop = prop;
        }

        public Degree() {
            this(0, 0, 0);
        }

        public void add(Degree d) {
            this.in += d.in;
            this.out += d.out;
            this.both += d.both;
            this.prop += d.prop;
        }
    }

    public static class DegreeMapper
    extends StaticMapReduce<Long, Integer, Long, Integer, Map<Long, Integer>> {
        public static final String DEGREE_RESULT = "degrees";

        public boolean doStage(MapReduce.Stage stage) {
            return stage == MapReduce.Stage.MAP;
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Long, Integer> emitter) {
            emitter.emit((Object)((Long)vertex.id()), vertex.value("degree"));
        }

        public Map<Long, Integer> generateFinalResult(Iterator<KeyValue<Long, Integer>> keyValues) {
            HashMap<Long, Integer> result = new HashMap<Long, Integer>();
            while (keyValues.hasNext()) {
                KeyValue<Long, Integer> r = keyValues.next();
                result.put((Long)r.getKey(), (Integer)r.getValue());
            }
            return result;
        }

        public String getMemoryKey() {
            return DEGREE_RESULT;
        }
    }

    public static class DegreeCounter
    extends StaticVertexProgram<Integer> {
        public static final String DEGREE = "degree";
        public static final MessageCombiner<Integer> ADDITION = (MessageCombiner & Serializable)(a, b) -> a + b;
        public static final MessageScope.Local<Integer> DEG_MSG = MessageScope.Local.of(() -> __.inE((String[])new String[0]));
        private final int length;

        public DegreeCounter() {
            this(1);
        }

        public DegreeCounter(int length) {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0);
            this.length = length;
        }

        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<Integer> messenger, Memory memory) {
            if (memory.isInitialIteration()) {
                messenger.sendMessage(DEG_MSG, (Object)1);
            } else {
                int degree = IteratorUtils.stream((Iterator)messenger.receiveMessages()).reduce(0, (a, b) -> a + b);
                vertex.property(VertexProperty.Cardinality.single, DEGREE, (Object)degree, new Object[0]);
                if (memory.getIteration() < this.length) {
                    messenger.sendMessage(DEG_MSG, (Object)degree);
                }
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() >= this.length;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return new HashSet<VertexComputeKey>(Collections.singletonList(VertexComputeKey.of((String)DEGREE, (boolean)false)));
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return new HashSet<MemoryComputeKey>(Collections.singletonList(MemoryComputeKey.of((String)DEGREE, (BinaryOperator)Operator.assign, (boolean)true, (boolean)false)));
        }

        public Optional<MessageCombiner<Integer>> getMessageCombiner() {
            return Optional.of(ADDITION);
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            if (memory.getIteration() < this.length) {
                return ImmutableSet.of(DEG_MSG);
            }
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public VertexProgram.Features getFeatures() {
            return new VertexProgram.Features(){

                public boolean requiresLocalMessageScopes() {
                    return true;
                }

                public boolean requiresVertexPropertyAddition() {
                    return true;
                }
            };
        }
    }

    public static class ExceptionProgram
    extends StaticVertexProgram<Integer> {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<Integer> messenger, Memory memory) {
            throw new NullPointerException();
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 1;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return ImmutableSet.of();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public VertexProgram.Features getFeatures() {
            return new VertexProgram.Features(){

                public boolean requiresLocalMessageScopes() {
                    return true;
                }

                public boolean requiresVertexPropertyAddition() {
                    return true;
                }
            };
        }
    }
}

