/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConsumer
implements IResultsConsumer {
    private static final Logger log = LoggerFactory.getLogger(CsvConsumer.class);
    private final Writer csv;
    private final File csvFile;
    private final String separator = ",";

    public CsvConsumer(String fileName) throws IOException {
        this.csvFile = new File(fileName);
        log.debug("Opening {} in append mode", (Object)this.csvFile);
        this.csv = new OutputStreamWriter(new FileOutputStream(this.csvFile, true));
        this.printHeader();
    }

    public synchronized void accept(Result r) throws IOException {
        Joiner j = Joiner.on((String)",");
        ArrayList<String> fields = new ArrayList<String>(Column.values().length);
        for (Column c : Column.values()) {
            fields.add(c.get(r));
        }
        this.csv.write(String.format("%s%n", j.join(fields)));
        log.debug("Wrote {} to {}", (Object)r, (Object)this.csvFile);
        this.csv.flush();
    }

    private synchronized void printHeader() throws IOException {
        long len = this.csvFile.length();
        if (0L != len) {
            log.debug("Not writing header to {}; file has non-zero length {}", (Object)this.csvFile, (Object)len);
            return;
        }
        Joiner j = Joiner.on((String)",");
        ArrayList<String> headers = new ArrayList<String>(Column.values().length);
        for (Column c : Column.values()) {
            headers.add(c.getName());
        }
        this.csv.write(String.format("%s%n", j.join(headers)));
        log.debug("Wrote header to {}", (Object)this.csvFile);
        this.csv.flush();
    }

    public static enum Column {
        CLASS_NAME("class.name"){

            @Override
            public String get(Result r) {
                return r.getShortTestClassName();
            }
        }
        ,
        METHOD_NAME("method.name"){

            @Override
            public String get(Result r) {
                return r.getTestMethodName();
            }
        }
        ,
        ROUND_COUNT("round.measured"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.benchmarkRounds);
            }
        }
        ,
        ROUND_WARMUP("round.warmup"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.warmupRounds);
            }
        }
        ,
        ROUND_AVG("round.time"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.roundAverage.avg);
            }
        }
        ,
        ROUND_AVG_STDEV("round.time.stdev"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.roundAverage.stddev);
            }
        }
        ,
        ROUND_BLOCK("round.block"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.blockedAverage.avg);
            }
        }
        ,
        ROUND_BLOCK_STDEV("round.block.stdev"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.roundAverage.stddev);
            }
        }
        ,
        ROUND_GC("round.gc"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.gcAverage.avg);
            }
        }
        ,
        ROUND_GC_STDEV("round.gc.stdev"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.gcAverage.stddev);
            }
        }
        ,
        GC_CALLS("gc.calls"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.gcInfo.accumulatedInvocations());
            }
        }
        ,
        GC_TIME("gc.time"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.gcInfo.accumulatedTime() / 1000L);
            }
        }
        ,
        TIME_TOTAL("time.total"){

            @Override
            public String get(Result r) {
                return String.valueOf((r.benchmarkTime + r.warmupTime) / 1000L);
            }
        }
        ,
        TIME_WARMUP("time.warmup"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.warmupTime / 1000L);
            }
        }
        ,
        TIME_BENCH("time.bench"){

            @Override
            public String get(Result r) {
                return String.valueOf(r.benchmarkTime / 1000L);
            }
        };

        private final String name;

        public abstract String get(Result var1);

        private Column(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

