/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.janusgraph.testutil.FlakyTest;
import org.janusgraph.testutil.RetryTemplateContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;

public class FlakyTestExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationUtils.isAnnotated((Optional)context.getTestMethod(), FlakyTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        FlakyTest annotation = (FlakyTest)context.getTestMethod().flatMap(testMethods -> AnnotationSupport.findAnnotation((AnnotatedElement)testMethods, FlakyTest.class)).orElseThrow(() -> new ExtensionContextException("The extension should not be executed unless the test method is annotated with @FlakyTest."));
        this.checkValidRetry(annotation);
        return IntStream.rangeClosed(1, annotation.invocationCount()).mapToObj(it -> new RetryTemplateContext(it, annotation.invocationCount(), annotation.minSuccess()));
    }

    private void checkValidRetry(FlakyTest annotation) {
        if (annotation.invocationCount() < 1) {
            throw new ExtensionContextException(annotation.invocationCount() + " must be greater than or equal to 1");
        }
        if (annotation.minSuccess() < 1 || annotation.minSuccess() > annotation.invocationCount()) {
            throw new ExtensionContextException("Invalid " + annotation.minSuccess());
        }
    }
}

