/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.junit.jupiter.api.Assertions;

public class JanusGraphAssert {
    public static void assertCount(int expected, Traversal traversal) {
        Assertions.assertEquals((int)expected, (int)traversal.toList().size());
    }

    public static void assertCount(int expected, Collection collection) {
        Assertions.assertEquals((int)expected, (int)collection.size());
    }

    public static void assertCount(int expected, Iterable iterable) {
        Assertions.assertEquals((int)expected, (int)Iterables.size((Iterable)iterable));
    }

    public static void assertCount(int expected, Iterator iterator) {
        Assertions.assertEquals((int)expected, (int)Iterators.size((Iterator)iterator));
    }

    public static void assertCount(long expected, Stream stream) {
        Assertions.assertEquals((long)expected, (long)stream.count());
    }

    public static <V extends Element> void assertEmpty(Object object) {
        Assertions.assertTrue((boolean)JanusGraphAssert.isEmpty(object));
    }

    public static <V extends Element> void assertNotEmpty(Object object) {
        Assertions.assertFalse((boolean)JanusGraphAssert.isEmpty(object));
    }

    public static <E extends Element> void assertTraversal(GraphTraversal<?, E> req, E ... expectedElements) {
        for (E expectedElement : expectedElements) {
            Assertions.assertEquals(expectedElement, (Object)req.next());
        }
        Assertions.assertFalse((boolean)req.hasNext());
    }

    private static boolean isEmpty(Object obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0);
        if (obj instanceof Traversal) {
            return !((Traversal)obj).hasNext();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return Iterables.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (obj instanceof Stream) {
            return ((Stream)obj).count() == 0L;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        throw new IllegalArgumentException("Cannot determine size of: " + obj);
    }
}

