/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import java.time.Instant;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimestamps {
    @Test
    public void testMicro() {
        this.testRoundTrip((TimestampProvider)TimestampProviders.MICRO);
        Assertions.assertEquals((Object)Instant.ofEpochSecond(1000L), (Object)TimestampProviders.MICRO.getTime(1000000000L));
    }

    @Test
    public void testMilli() {
        this.testRoundTrip((TimestampProvider)TimestampProviders.MILLI);
    }

    @Test
    public void testNano() {
        this.testRoundTrip((TimestampProvider)TimestampProviders.NANO);
    }

    private void testRoundTrip(TimestampProvider p) {
        Instant now = p.getTime();
        long time = p.getTime(now);
        Instant now2 = p.getTime(time);
        Assertions.assertEquals((Object)now, (Object)now2);
    }
}

