/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.embedded;

import org.janusgraph.CassandraStorageSetup;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreTest;
import org.janusgraph.diskstorage.cassandra.embedded.CassandraEmbeddedStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.testcategory.OrderedKeyStoreTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class EmbeddedStoreTest
extends AbstractCassandraStoreTest {
    @BeforeClass
    public static void startCassandra() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    @Override
    public ModifiableConfiguration getBaseStorageConfiguration() {
        return this.getBaseStorageConfiguration(((Object)((Object)this)).getClass().getSimpleName());
    }

    @Override
    public ModifiableConfiguration getBaseStorageConfiguration(String keyspace) {
        return CassandraStorageSetup.getEmbeddedConfiguration(keyspace);
    }

    @Override
    public AbstractCassandraStoreManager openStorageManager(Configuration c) throws BackendException {
        return new CassandraEmbeddedStoreManager(c);
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testConfiguration() {
        StoreFeatures features = this.manager.getFeatures();
        Assert.assertTrue((boolean)features.isKeyOrdered());
        Assert.assertTrue((boolean)features.hasLocalKeyPartition());
    }
}

