/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.thrift;

import org.janusgraph.CassandraStorageSetup;
import org.janusgraph.diskstorage.cassandra.thrift.CassandraThriftStoreManager;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class CassandraThriftStoreManagerTest {
    @Test(expected=IllegalArgumentException.class)
    public void configOptionFrameSizeMbShouldErrorOnLowValue() {
        ModifiableConfiguration config = CassandraStorageSetup.getCassandraThriftConfiguration("janusgraph");
        config.set(CassandraThriftStoreManager.THRIFT_FRAME_SIZE_MB, (Object)0, new String[0]);
        config.get(CassandraThriftStoreManager.THRIFT_FRAME_SIZE_MB, new String[0]);
    }

    @Test
    public void configOptionFrameSizeMbShouldBeHappy() {
        ModifiableConfiguration config = CassandraStorageSetup.getCassandraThriftConfiguration("janusgraph");
        config.set(CassandraThriftStoreManager.THRIFT_FRAME_SIZE_MB, (Object)1, new String[0]);
        Integer result = (Integer)config.get(CassandraThriftStoreManager.THRIFT_FRAME_SIZE_MB, new String[0]);
        Assert.assertEquals((long)1L, (long)result.intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void configOptionFrameSizeMbShouldErrorOnHighValue() {
        ModifiableConfiguration config = CassandraStorageSetup.getCassandraThriftConfiguration("janusgraph");
        config.set(CassandraThriftStoreManager.THRIFT_FRAME_SIZE_MB, (Object)2048, new String[0]);
        config.get(CassandraThriftStoreManager.THRIFT_FRAME_SIZE_MB, new String[0]);
    }
}

