/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.CLevel;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTransaction
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(CassandraTransaction.class);
    private final CLevel read = CLevel.parse((String)this.getConfiguration().getCustomOption(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY));
    private final CLevel write = CLevel.parse((String)this.getConfiguration().getCustomOption(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY));

    public CassandraTransaction(BaseTransactionConfig c) {
        super(c);
        log.debug("Created {}", (Object)this.toString());
    }

    public CLevel getReadConsistencyLevel() {
        return this.read;
    }

    public CLevel getWriteConsistencyLevel() {
        return this.write;
    }

    public static CassandraTransaction getTx(StoreTransaction txh) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(txh instanceof CassandraTransaction), (String)"Unexpected transaction type %s", (Object[])new Object[]{txh.getClass().getName()});
        return (CassandraTransaction)txh;
    }

    public String toString() {
        return "CassandraTransaction@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "[read=" + this.read + ",write=" + this.write + "]";
    }
}

