/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Pending;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.SummaryPrinter;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Reflections;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.ScenarioImpl;
import cucumber.runtime.Stats;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.StopWatch;
import cucumber.runtime.UndefinedStepException;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Runtime
implements UnreportedStepExecutor {
    private static final String[] PENDING_EXCEPTIONS = new String[]{"org.junit.internal.AssumptionViolatedException"};
    private static final Object DUMMY_ARG;
    private static final byte ERRORS = 1;
    private final Stats stats;
    final UndefinedStepsTracker undefinedStepsTracker = new UndefinedStepsTracker();
    private final Glue glue;
    private final RuntimeOptions runtimeOptions;
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final Collection<? extends Backend> backends;
    private final ResourceLoader resourceLoader;
    private final ClassLoader classLoader;
    private final StopWatch stopWatch;
    private boolean skipNextStep = false;
    private ScenarioImpl scenarioResult = null;

    public Runtime(ResourceLoader resourceLoader, ClassFinder classFinder, ClassLoader classLoader, RuntimeOptions runtimeOptions) {
        this(resourceLoader, classLoader, Runtime.loadBackends(resourceLoader, classFinder), runtimeOptions);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions) {
        this(resourceLoader, classLoader, backends, runtimeOptions, StopWatch.SYSTEM, null);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions, RuntimeGlue optionalGlue) {
        this(resourceLoader, classLoader, backends, runtimeOptions, StopWatch.SYSTEM, optionalGlue);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions, StopWatch stopWatch, RuntimeGlue optionalGlue) {
        if (backends.isEmpty()) {
            throw new CucumberException("No backends were found. Please make sure you have a backend module on your CLASSPATH.");
        }
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
        this.backends = backends;
        this.runtimeOptions = runtimeOptions;
        this.stopWatch = stopWatch;
        this.glue = optionalGlue != null ? optionalGlue : new RuntimeGlue(this.undefinedStepsTracker, new LocalizedXStreams(classLoader));
        this.stats = new Stats(runtimeOptions.isMonochrome());
        for (Backend backend : backends) {
            backend.loadGlue(this.glue, runtimeOptions.getGlue());
            backend.setUnreportedStepExecutor(this);
        }
    }

    private static Collection<? extends Backend> loadBackends(ResourceLoader resourceLoader, ClassFinder classFinder) {
        Reflections reflections = new Reflections(classFinder);
        return reflections.instantiateSubclasses(Backend.class, "cucumber.runtime", new Class[]{ResourceLoader.class}, new Object[]{resourceLoader});
    }

    public void addError(Throwable error) {
        this.errors.add(error);
    }

    public void run() throws IOException {
        List<CucumberFeature> features = this.runtimeOptions.cucumberFeatures(this.resourceLoader);
        Formatter formatter = this.runtimeOptions.formatter(this.classLoader);
        Reporter reporter = this.runtimeOptions.reporter(this.classLoader);
        StepDefinitionReporter stepDefinitionReporter = this.runtimeOptions.stepDefinitionReporter(this.classLoader);
        this.glue.reportStepDefinitions(stepDefinitionReporter);
        for (CucumberFeature cucumberFeature : features) {
            cucumberFeature.run(formatter, reporter, this);
        }
        formatter.done();
        formatter.close();
        this.printSummary();
    }

    public void printSummary() {
        SummaryPrinter summaryPrinter = this.runtimeOptions.summaryPrinter(this.classLoader);
        summaryPrinter.print(this);
    }

    void printStats(PrintStream out) {
        this.stats.printStats(out, this.runtimeOptions.isStrict());
    }

    public void buildBackendWorlds(Reporter reporter, Set<Tag> tags, Scenario gherkinScenario) {
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
        this.undefinedStepsTracker.reset();
        this.skipNextStep = false;
        this.scenarioResult = new ScenarioImpl(reporter, tags, gherkinScenario);
    }

    public void disposeBackendWorlds(String scenarioDesignation) {
        this.stats.addScenario(this.scenarioResult.getStatus(), scenarioDesignation);
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public byte exitStatus() {
        byte result = 0;
        if (this.hasErrors() || this.hasUndefinedOrPendingStepsAndIsStrict()) {
            result = (byte)(result | 1);
        }
        return result;
    }

    private boolean hasUndefinedOrPendingStepsAndIsStrict() {
        return this.runtimeOptions.isStrict() && this.hasUndefinedOrPendingSteps();
    }

    private boolean hasUndefinedOrPendingSteps() {
        return this.hasUndefinedSteps() || this.hasPendingSteps();
    }

    private boolean hasUndefinedSteps() {
        return this.undefinedStepsTracker.hasUndefinedSteps();
    }

    private boolean hasPendingSteps() {
        return !this.errors.isEmpty() && !this.hasErrors();
    }

    private boolean hasErrors() {
        for (Throwable error : this.errors) {
            if (Runtime.isPending(error)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSnippets() {
        return this.undefinedStepsTracker.getSnippets(this.backends, this.runtimeOptions.getSnippetType().getFunctionNameGenerator());
    }

    public Glue getGlue() {
        return this.glue;
    }

    public void runBeforeHooks(Reporter reporter, Set<Tag> tags) {
        this.runHooks(this.glue.getBeforeHooks(), reporter, tags, true);
    }

    public void runAfterHooks(Reporter reporter, Set<Tag> tags) {
        this.runHooks(this.glue.getAfterHooks(), reporter, tags, false);
    }

    private void runHooks(List<HookDefinition> hooks, Reporter reporter, Set<Tag> tags, boolean isBefore) {
        if (!this.runtimeOptions.isDryRun()) {
            for (HookDefinition hook : hooks) {
                this.runHookIfTagsMatch(hook, reporter, tags, isBefore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHookIfTagsMatch(HookDefinition hook, Reporter reporter, Set<Tag> tags, boolean isBefore) {
        if (hook.matches(tags)) {
            String status = "passed";
            Throwable error = null;
            Match match = new Match(Collections.<Argument>emptyList(), hook.getLocation(false));
            this.stopWatch.start();
            try {
                hook.execute(this.scenarioResult);
            }
            catch (Throwable t) {
                error = t;
                status = Runtime.isPending(t) ? "pending" : "failed";
                this.addError(t);
                this.skipNextStep = true;
            }
            finally {
                long duration = this.stopWatch.stop();
                Result result = new Result(status, duration, error, DUMMY_ARG);
                this.addHookToCounterAndResult(result);
                if (isBefore) {
                    reporter.before(match, result);
                } else {
                    reporter.after(match, result);
                }
            }
        }
    }

    @Override
    public void runUnreportedStep(String featurePath, I18n i18n, String stepKeyword, String stepName, int line, List<DataTableRow> dataTableRows, DocString docString) throws Throwable {
        Step step = new Step(Collections.<Comment>emptyList(), stepKeyword, stepName, line, dataTableRows, docString);
        StepDefinitionMatch match = this.glue.stepDefinitionMatch(featurePath, step, i18n);
        if (match == null) {
            UndefinedStepException error = new UndefinedStepException(step);
            StackTraceElement[] originalTrace = error.getStackTrace();
            StackTraceElement[] newTrace = new StackTraceElement[originalTrace.length + 1];
            newTrace[0] = new StackTraceElement("\u273d", "StepDefinition", featurePath, line);
            System.arraycopy(originalTrace, 0, newTrace, 1, originalTrace.length);
            error.setStackTrace(newTrace);
            throw error;
        }
        match.runStep(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStep(String featurePath, Step step, Reporter reporter, I18n i18n) {
        StepDefinitionMatch match;
        try {
            match = this.glue.stepDefinitionMatch(featurePath, step, i18n);
        }
        catch (AmbiguousStepDefinitionsException e) {
            reporter.match(e.getMatches().get(0));
            Result result = new Result("failed", 0L, e, DUMMY_ARG);
            reporter.result(result);
            this.addStepToCounterAndResult(result);
            this.addError(e);
            this.skipNextStep = true;
            return;
        }
        if (match == null) {
            reporter.match(Match.UNDEFINED);
            reporter.result(Result.UNDEFINED);
            this.addStepToCounterAndResult(Result.UNDEFINED);
            this.skipNextStep = true;
            return;
        }
        reporter.match(match);
        if (this.runtimeOptions.isDryRun()) {
            this.skipNextStep = true;
        }
        if (this.skipNextStep) {
            this.addStepToCounterAndResult(Result.SKIPPED);
            reporter.result(Result.SKIPPED);
        } else {
            String status = "passed";
            Throwable error = null;
            this.stopWatch.start();
            try {
                match.runStep(i18n);
            }
            catch (Throwable t) {
                error = t;
                status = Runtime.isPending(t) ? "pending" : "failed";
                this.addError(t);
                this.skipNextStep = true;
            }
            finally {
                long duration = this.stopWatch.stop();
                Result result = new Result(status, duration, error, DUMMY_ARG);
                this.addStepToCounterAndResult(result);
                reporter.result(result);
            }
        }
    }

    public static boolean isPending(Throwable t) {
        if (t == null) {
            return false;
        }
        return t.getClass().isAnnotationPresent(Pending.class) || Arrays.binarySearch(PENDING_EXCEPTIONS, t.getClass().getName()) >= 0;
    }

    private void addStepToCounterAndResult(Result result) {
        this.scenarioResult.add(result);
        this.stats.addStep(result);
    }

    private void addHookToCounterAndResult(Result result) {
        this.scenarioResult.add(result);
        this.stats.addHookTime(result.getDuration());
    }

    static {
        Arrays.sort(PENDING_EXCEPTIONS);
        DUMMY_ARG = new Object();
    }
}

