/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.formatter.StrictAware;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RerunFormatter
implements Formatter,
Reporter,
StrictAware {
    private final NiceAppendable out;
    private String featureLocation;
    private Scenario scenario;
    private boolean isTestFailed = false;
    private Map<String, ArrayList<Integer>> featureAndFailedLinesMapping = new HashMap<String, ArrayList<Integer>>();
    private boolean isStrict = false;

    public RerunFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void uri(String uri) {
        this.featureLocation = uri;
    }

    @Override
    public void feature(Feature feature) {
    }

    @Override
    public void background(Background background) {
    }

    @Override
    public void scenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    @Override
    public void examples(Examples examples) {
    }

    @Override
    public void step(Step step) {
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    @Override
    public void done() {
        this.reportFailedScenarios();
    }

    private void reportFailedScenarios() {
        Set<Map.Entry<String, ArrayList<Integer>>> entries = this.featureAndFailedLinesMapping.entrySet();
        boolean firstFeature = true;
        for (Map.Entry<String, ArrayList<Integer>> entry : entries) {
            if (entry.getValue().size() <= 0) continue;
            if (!firstFeature) {
                this.out.append(" ");
            }
            this.out.append(entry.getKey());
            firstFeature = false;
            for (Integer line : entry.getValue()) {
                this.out.append(":").append(line.toString());
            }
        }
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.isTestFailed = false;
    }

    @Override
    public void endOfScenarioLifeCycle(Scenario scenario) {
        if (this.isTestFailed) {
            this.recordTestFailed();
        }
    }

    @Override
    public void before(Match match, Result result) {
        if (this.isTestFailed(result)) {
            this.isTestFailed = true;
        }
    }

    @Override
    public void result(Result result) {
        if (this.isTestFailed(result)) {
            this.isTestFailed = true;
        }
    }

    private boolean isTestFailed(Result result) {
        String status = result.getStatus();
        return "failed".equals(status) || this.isStrict && (Result.UNDEFINED.getStatus().equals(status) || "pending".equals(status));
    }

    private void recordTestFailed() {
        ArrayList<Integer> failedScenarios = this.featureAndFailedLinesMapping.get(this.featureLocation);
        if (failedScenarios == null) {
            failedScenarios = new ArrayList();
            this.featureAndFailedLinesMapping.put(this.featureLocation, failedScenarios);
        }
        failedScenarios.add(this.scenario.getLine());
    }

    @Override
    public void after(Match match, Result result) {
        if (this.isTestFailed(result)) {
            this.isTestFailed = true;
        }
    }

    @Override
    public void match(Match match) {
    }

    @Override
    public void embedding(String mimeType, byte[] data) {
    }

    @Override
    public void write(String text) {
    }

    @Override
    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }
}

