/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.Scenario;
import cucumber.api.java8.HookBody;
import cucumber.api.java8.HookNoArgsBody;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Timeout;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.util.Arrays;
import java.util.Collection;

public class Java8HookDefinition
implements HookDefinition {
    private final TagExpression tagExpression;
    private final int order;
    private final long timeoutMillis;
    private final HookNoArgsBody hookNoArgsBody;
    private final HookBody hookBody;
    private final StackTraceElement location;

    private Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookBody hookBody, HookNoArgsBody hookNoArgsBody) {
        this.order = order;
        this.timeoutMillis = timeoutMillis;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.hookBody = hookBody;
        this.hookNoArgsBody = hookNoArgsBody;
        this.location = new Exception().getStackTrace()[3];
    }

    public Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookBody hookBody) {
        this(tagExpressions, order, timeoutMillis, hookBody, null);
    }

    public Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookNoArgsBody hookNoArgsBody) {
        this(tagExpressions, order, timeoutMillis, null, hookNoArgsBody);
    }

    @Override
    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    @Override
    public void execute(final Scenario scenario) throws Throwable {
        Timeout.timeout(new Timeout.Callback<Object>(){

            @Override
            public Object call() throws Throwable {
                if (Java8HookDefinition.this.hookBody != null) {
                    Java8HookDefinition.this.hookBody.accept(scenario);
                } else {
                    Java8HookDefinition.this.hookNoArgsBody.accept();
                }
                return null;
            }
        }, this.timeoutMillis);
    }

    @Override
    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.evaluate(tags);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean isScenarioScoped() {
        return true;
    }
}

