/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java.ObjectFactory;
import cucumber.api.java8.GlueBase;
import cucumber.api.java8.HookBody;
import cucumber.api.java8.HookNoArgsBody;
import cucumber.api.java8.StepdefBody;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Env;
import cucumber.runtime.Glue;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.Java8HookDefinition;
import cucumber.runtime.java.Java8Snippet;
import cucumber.runtime.java.Java8StepDefinition;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.MethodScanner;
import cucumber.runtime.java.ObjectFactoryLoader;
import cucumber.runtime.java.TypeIntrospector;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class JavaBackend
implements Backend {
    public static final ThreadLocal<JavaBackend> INSTANCE = new ThreadLocal();
    private final SnippetGenerator snippetGenerator = new SnippetGenerator(this.createSnippet());
    private final ObjectFactory objectFactory;
    private final ClassFinder classFinder;
    private final MethodScanner methodScanner;
    private Glue glue;
    private List<Class<? extends GlueBase>> glueBaseClasses = new ArrayList<Class<? extends GlueBase>>();

    private Snippet createSnippet() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("cucumber.runtime.java8.LambdaGlueBase");
            return new Java8Snippet();
        }
        catch (ClassNotFoundException thatsOk) {
            return new JavaSnippet();
        }
    }

    public JavaBackend(ResourceLoader resourceLoader) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        this.methodScanner = new MethodScanner(this.classFinder);
        this.objectFactory = ObjectFactoryLoader.loadObjectFactory(this.classFinder, Env.INSTANCE.get(ObjectFactory.class.getName()));
    }

    public JavaBackend(ObjectFactory objectFactory) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        this.methodScanner = new MethodScanner(this.classFinder);
        this.objectFactory = objectFactory;
    }

    public JavaBackend(ObjectFactory objectFactory, ClassFinder classFinder) {
        this.objectFactory = objectFactory;
        this.classFinder = classFinder;
        this.methodScanner = new MethodScanner(classFinder);
    }

    @Override
    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.methodScanner.scan(this, gluePaths);
        for (String gluePath : gluePaths) {
            Collection<Class<GlueBase>> glueDefinerClasses = this.classFinder.getDescendants(GlueBase.class, MultiLoader.packageName(gluePath));
            for (Class<GlueBase> glueClass : glueDefinerClasses) {
                if (glueClass.isInterface() || !this.objectFactory.addClass(glueClass)) continue;
                this.glueBaseClasses.add(glueClass);
            }
        }
    }

    public void loadGlue(Glue glue, Method method, Class<?> glueCodeClass) {
        this.glue = glue;
        this.methodScanner.scan(this, method, glueCodeClass);
    }

    @Override
    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    @Override
    public void buildWorld() {
        this.objectFactory.start();
        try {
            INSTANCE.set(this);
            this.glue.removeScenarioScopedGlue();
            for (Class<? extends GlueBase> glueBaseClass : this.glueBaseClasses) {
                this.objectFactory.getInstance(glueBaseClass);
            }
        }
        finally {
            INSTANCE.remove();
        }
    }

    @Override
    public void disposeWorld() {
        this.objectFactory.stop();
    }

    @Override
    public String getSnippet(Step step, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, functionNameGenerator);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            if (this.objectFactory.addClass(method.getDeclaringClass())) {
                this.glue.addStepDefinition(new JavaStepDefinition(method, this.pattern(annotation), this.timeoutMillis(annotation), this.objectFactory));
            }
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    public void addStepDefinition(String regexp, long timeoutMillis, StepdefBody body, TypeIntrospector typeIntrospector) {
        try {
            this.glue.addStepDefinition(new Java8StepDefinition(Pattern.compile(regexp), timeoutMillis, body, typeIntrospector));
        }
        catch (Exception e) {
            throw new CucumberException(e);
        }
    }

    void addHook(Annotation annotation, Method method) {
        if (this.objectFactory.addClass(method.getDeclaringClass())) {
            if (annotation.annotationType().equals(Before.class)) {
                String[] tagExpressions = ((Before)annotation).value();
                long timeout = ((Before)annotation).timeout();
                this.glue.addBeforeHook(new JavaHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, this.objectFactory));
            } else {
                String[] tagExpressions = ((After)annotation).value();
                long timeout = ((After)annotation).timeout();
                this.glue.addAfterHook(new JavaHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, this.objectFactory));
            }
        }
    }

    public void addBeforeHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookBody body) {
        this.glue.addBeforeHook(new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    public void addAfterHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookBody body) {
        this.glue.addAfterHook(new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    public void addBeforeHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookNoArgsBody body) {
        this.glue.addBeforeHook(new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    public void addAfterHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookNoArgsBody body) {
        this.glue.addAfterHook(new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke(annotation, regexpMethod, 0L, new Object[0]);
        return Pattern.compile(regexpString);
    }

    private long timeoutMillis(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke(annotation, regexpMethod, 0L, new Object[0]);
    }
}

