/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.Scenario;
import cucumber.api.java.ObjectFactory;
import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.Utils;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

class JavaHookDefinition
implements HookDefinition {
    private final Method method;
    private final long timeoutMillis;
    private final TagExpression tagExpression;
    private final int order;
    private final ObjectFactory objectFactory;

    public JavaHookDefinition(Method method, String[] tagExpressions, int order, long timeoutMillis, ObjectFactory objectFactory) {
        this.method = method;
        this.timeoutMillis = timeoutMillis;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.order = order;
        this.objectFactory = objectFactory;
    }

    Method getMethod() {
        return this.method;
    }

    @Override
    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    @Override
    public void execute(Scenario scenario) throws Throwable {
        Object[] args;
        switch (this.method.getParameterTypes().length) {
            case 0: {
                args = new Object[]{};
                break;
            }
            case 1: {
                if (!Scenario.class.equals(this.method.getParameterTypes()[0])) {
                    throw new CucumberException("When a hook declares an argument it must be of type " + Scenario.class.getName() + ". " + this.method.toString());
                }
                args = new Object[]{scenario};
                break;
            }
            default: {
                throw new CucumberException("Hooks must declare 0 or 1 arguments. " + this.method.toString());
            }
        }
        Utils.invoke(this.objectFactory.getInstance(this.method.getDeclaringClass()), this.method, this.timeoutMillis, args);
    }

    @Override
    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.evaluate(tags);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean isScenarioScoped() {
        return false;
    }
}

