/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.StepDefAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class MethodScanner {
    private final Collection<Class<? extends Annotation>> cucumberAnnotationClasses;
    private final ClassFinder classFinder;

    public MethodScanner(ClassFinder classFinder) {
        this.classFinder = classFinder;
        this.cucumberAnnotationClasses = this.findCucumberAnnotationClasses();
    }

    public void scan(JavaBackend javaBackend, List<String> gluePaths) {
        for (String gluePath : gluePaths) {
            Iterator<Class<Object>> iterator = this.classFinder.getDescendants(Object.class, MultiLoader.packageName(gluePath)).iterator();
            while (iterator.hasNext()) {
                Class<Object> glueCodeClass;
                for (glueCodeClass = iterator.next(); glueCodeClass != null && glueCodeClass != Object.class && !Utils.isInstantiable(glueCodeClass); glueCodeClass = glueCodeClass.getSuperclass()) {
                }
                if (glueCodeClass == null) continue;
                for (Method method : glueCodeClass.getMethods()) {
                    this.scan(javaBackend, method, glueCodeClass);
                }
            }
        }
    }

    public void scan(JavaBackend javaBackend, Method method, Class<?> glueCodeClass) {
        for (Class<? extends Annotation> cucumberAnnotationClass : this.cucumberAnnotationClasses) {
            Annotation annotation = method.getAnnotation(cucumberAnnotationClass);
            if (annotation == null) continue;
            if (!method.getDeclaringClass().isAssignableFrom(glueCodeClass)) {
                throw new CucumberException(String.format("%s isn't assignable from %s", method.getDeclaringClass(), glueCodeClass));
            }
            if (!glueCodeClass.equals(method.getDeclaringClass())) {
                throw new CucumberException(String.format("You're not allowed to extend classes that define Step Definitions or hooks. %s extends %s", glueCodeClass, method.getDeclaringClass()));
            }
            if (this.isHookAnnotation(annotation)) {
                javaBackend.addHook(annotation, method);
                continue;
            }
            if (!this.isStepdefAnnotation(annotation)) continue;
            javaBackend.addStepDefinition(annotation, method);
        }
    }

    private Collection<Class<? extends Annotation>> findCucumberAnnotationClasses() {
        return this.classFinder.getDescendants(Annotation.class, "cucumber.api");
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }
}

