/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.guice.impl;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import cucumber.runtime.java.guice.ScenarioScope;
import java.util.HashMap;
import java.util.Map;

public class SequentialScenarioScope
implements ScenarioScope {
    private Map<Key<?>, Object> scenarioValues = null;

    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            @Override
            public T get() {
                if (SequentialScenarioScope.this.scenarioValues == null) {
                    throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
                }
                Object current = SequentialScenarioScope.this.scenarioValues.get(key);
                if (current == null && !SequentialScenarioScope.this.scenarioValues.containsKey(key)) {
                    current = unscoped.get();
                    SequentialScenarioScope.this.scenarioValues.put(key, current);
                }
                return current;
            }
        };
    }

    @Override
    public void enterScope() {
        this.checkState(this.scenarioValues == null, "A scoping block is already in progress");
        this.scenarioValues = new HashMap();
    }

    @Override
    public void exitScope() {
        this.checkState(this.scenarioValues != null, "No scoping block in progress");
        this.scenarioValues = null;
    }

    private void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }
}

