/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CucumberExamples {
    private final CucumberScenarioOutline cucumberScenarioOutline;
    private final Examples examples;

    public CucumberExamples(CucumberScenarioOutline cucumberScenarioOutline, Examples examples) {
        this.cucumberScenarioOutline = cucumberScenarioOutline;
        this.examples = examples;
    }

    public List<CucumberScenario> createExampleScenarios() {
        ArrayList<CucumberScenario> exampleScenarios = new ArrayList<CucumberScenario>();
        List<ExamplesTableRow> rows = this.examples.getRows();
        ArrayList<Tag> tags = new ArrayList<Tag>(this.tagsAndInheritedTags());
        for (int i = 1; i < rows.size(); ++i) {
            exampleScenarios.add(this.cucumberScenarioOutline.createExampleScenario(rows.get(0), rows.get(i), tags, this.examples.getDescription()));
        }
        return exampleScenarios;
    }

    private Set<Tag> tagsAndInheritedTags() {
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.addAll(this.cucumberScenarioOutline.tagsAndInheritedTags());
        tags.addAll(this.examples.getTags());
        return tags;
    }

    public Examples getExamples() {
        return this.examples;
    }

    public void format(Formatter formatter) {
        this.examples.replay(formatter);
    }
}

