/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberBackground;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberTagStatement;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Tag;
import java.util.Set;

public class CucumberScenario
extends CucumberTagStatement {
    private final CucumberBackground cucumberBackground;
    private final Scenario scenario;

    public CucumberScenario(CucumberFeature cucumberFeature, CucumberBackground cucumberBackground, Scenario scenario) {
        super(cucumberFeature, scenario);
        this.cucumberBackground = cucumberBackground;
        this.scenario = scenario;
    }

    public CucumberScenario(CucumberFeature cucumberFeature, CucumberBackground cucumberBackground, Scenario exampleScenario, Row example) {
        super(cucumberFeature, exampleScenario, example);
        this.cucumberBackground = cucumberBackground;
        this.scenario = exampleScenario;
    }

    public CucumberBackground getCucumberBackground() {
        return this.cucumberBackground;
    }

    @Override
    public void run(Formatter formatter, Reporter reporter, Runtime runtime) {
        Set<Tag> tags = this.tagsAndInheritedTags();
        runtime.buildBackendWorlds(reporter, tags, this.scenario);
        formatter.startOfScenarioLifeCycle((Scenario)this.getGherkinModel());
        runtime.runBeforeHooks(reporter, tags);
        this.runBackground(formatter, reporter, runtime);
        this.format(formatter);
        this.runSteps(reporter, runtime);
        runtime.runAfterHooks(reporter, tags);
        formatter.endOfScenarioLifeCycle((Scenario)this.getGherkinModel());
        runtime.disposeBackendWorlds(this.createScenarioDesignation());
    }

    private String createScenarioDesignation() {
        return this.cucumberFeature.getPath() + ":" + Integer.toString(this.scenario.getLine()) + " # " + this.scenario.getKeyword() + ": " + this.scenario.getName();
    }

    private void runBackground(Formatter formatter, Reporter reporter, Runtime runtime) {
        if (this.cucumberBackground != null) {
            this.cucumberBackground.format(formatter);
            this.cucumberBackground.runSteps(reporter, runtime);
        }
    }
}

