/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import cucumber.runtime.xstream.ClassWithStringAssignableConstructorConverter;
import cucumber.runtime.xstream.DynamicClassBasedSingleValueConverter;
import cucumber.runtime.xstream.SingleValueConverterWrapperExt;
import java.lang.reflect.Constructor;

class DynamicClassWithStringAssignableConverter
extends DynamicClassBasedSingleValueConverter {
    DynamicClassWithStringAssignableConverter() {
    }

    @Override
    public SingleValueConverterWrapper converterForClass(Class type) {
        Constructor assignableConstructor = DynamicClassWithStringAssignableConverter.findAssignableConstructor(type);
        return new SingleValueConverterWrapperExt(new ClassWithStringAssignableConstructorConverter(assignableConstructor));
    }

    @Override
    public boolean canConvert(Class type) {
        return null != DynamicClassWithStringAssignableConverter.findAssignableConstructor(type);
    }

    private static Constructor findAssignableConstructor(Class type) {
        for (Constructor<?> constructor : type.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(String.class)) continue;
            return constructor;
        }
        return null;
    }
}

