/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternConverter
implements SingleValueConverter {
    private static final Pattern PATTERN_PATTERN = Pattern.compile("/(.*)/(.+)");

    @Override
    public String toString(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromString(String pattern) {
        Matcher matcher = PATTERN_PATTERN.matcher(pattern);
        if (matcher.matches()) {
            return Pattern.compile(matcher.group(1), this.flags(matcher.group(2)));
        }
        return Pattern.compile(pattern);
    }

    private int flags(String flags) {
        int result = 0;
        for (char c : flags.toCharArray()) {
            result |= this.flag(c);
        }
        return result;
    }

    private int flag(char c) {
        return FLAG.valueOf(String.valueOf(c)).modifier;
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Pattern.class);
    }

    private static enum FLAG {
        d(1),
        i(2),
        x(4),
        m(8),
        l(16),
        s(32),
        u(64),
        c(128);

        private final int modifier;

        private FLAG(int modifier) {
            this.modifier = modifier;
        }
    }
}

