/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter.ansi;

import gherkin.formatter.NiceAppendable;

public class AnsiEscapes {
    private static final char ESC = '\u001b';
    private static final char BRACKET = '[';
    public static AnsiEscapes RESET = AnsiEscapes.color(0);
    public static AnsiEscapes BLACK = AnsiEscapes.color(30);
    public static AnsiEscapes RED = AnsiEscapes.color(31);
    public static AnsiEscapes GREEN = AnsiEscapes.color(32);
    public static AnsiEscapes YELLOW = AnsiEscapes.color(33);
    public static AnsiEscapes BLUE = AnsiEscapes.color(34);
    public static AnsiEscapes MAGENTA = AnsiEscapes.color(35);
    public static AnsiEscapes CYAN = AnsiEscapes.color(36);
    public static AnsiEscapes WHITE = AnsiEscapes.color(37);
    public static AnsiEscapes DEFAULT = AnsiEscapes.color(9);
    public static AnsiEscapes GREY = AnsiEscapes.color(90);
    public static AnsiEscapes INTENSITY_BOLD = AnsiEscapes.color(1);
    private final String value;

    private static AnsiEscapes color(int code) {
        return new AnsiEscapes(String.valueOf(code) + "m");
    }

    public static AnsiEscapes up(int count) {
        return new AnsiEscapes(String.valueOf(count) + "A");
    }

    private AnsiEscapes(String value) {
        this.value = value;
    }

    public void appendTo(NiceAppendable a2) {
        a2.append('\u001b').append('[').append(this.value);
    }

    public void appendTo(StringBuilder a2) {
        a2.append('\u001b').append('[').append(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }
}

