/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class DeepDifference {
    private static final Map<Class<?>, Boolean> customEquals = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> customHash = new ConcurrentHashMap();

    public static List<Difference> determineDifferences(Object a2, Object b, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        HashSet<DualKey> visited = new HashSet<DualKey>();
        Deque<DualKey> toCompare = DeepDifference.initStack(a2, b, visited);
        ArrayList<Difference> differences = new ArrayList<Difference>();
        while (!toCompare.isEmpty()) {
            Object key2;
            DualKey dualKey = toCompare.removeFirst();
            visited.add(dualKey);
            List<String> currentPath = dualKey.getPath();
            Object key1 = dualKey.key1;
            if (key1 == (key2 = dualKey.key2)) continue;
            if (key1 == null || key2 == null) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (DeepDifference.hasCustomComparator(dualKey, comparatorByPropertyOrField, comparatorByType) && Objects.propertyOrFieldValuesAreEqual(key1, key2, dualKey.getConcatenatedPath(), comparatorByPropertyOrField, comparatorByType)) continue;
            if (key1 instanceof Collection) {
                if (!(key2 instanceof Collection)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof Collection) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedSet) {
                if (!(key2 instanceof SortedSet)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof SortedSet) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedMap) {
                if (!(key2 instanceof SortedMap)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof SortedMap) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Map) {
                if (!(key2 instanceof Map)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof Map) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1.getClass().isArray()) {
                if (DeepDifference.compareArrays(key1, key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedSet) {
                if (DeepDifference.compareOrderedCollection((Collection)key1, (Collection)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Set) {
                if (DeepDifference.compareUnorderedCollection((Collection)key1, (Collection)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Collection) {
                if (DeepDifference.compareOrderedCollection((Collection)key1, (Collection)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedMap) {
                if (DeepDifference.compareSortedMap((SortedMap)key1, (SortedMap)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Map) {
                if (DeepDifference.compareUnorderedMap((Map)key1, (Map)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (DeepDifference.hasCustomEquals(key1.getClass())) {
                if (key1.equals(key2)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            for (Field field : Objects.getDeclaredFieldsIncludingInherited(key1.getClass())) {
                ArrayList<String> path = new ArrayList<String>(currentPath);
                String fieldName = field.getName();
                path.add(fieldName);
                DualKey dk = new DualKey(path, PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, key1), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, key2));
                if (visited.contains(dk)) continue;
                toCompare.addFirst(dk);
            }
        }
        return differences;
    }

    private static boolean hasCustomComparator(DualKey dualKey, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        if (dualKey.key1.getClass() == dualKey.key2.getClass()) {
            String fieldName = dualKey.getConcatenatedPath();
            Comparator<?> fieldComparator = comparatorByPropertyOrField.containsKey(fieldName) ? comparatorByPropertyOrField.get(fieldName) : comparatorByType.get(dualKey.key1.getClass());
            return fieldComparator != null;
        }
        return false;
    }

    private static Deque<DualKey> initStack(Object a2, Object b, Set<DualKey> visited) {
        LinkedList<DualKey> stack = new LinkedList<DualKey>();
        if (a2 != null && !DeepDifference.isContainerType(a2)) {
            Set<Field> fieldsOfRootObject = Objects.getDeclaredFieldsIncludingInherited(a2.getClass());
            if (!fieldsOfRootObject.isEmpty()) {
                for (Field field : fieldsOfRootObject) {
                    String fieldName = field.getName();
                    DualKey dk = new DualKey(Arrays.asList(fieldName), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, a2), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, b));
                    if (visited.contains(dk)) continue;
                    stack.addFirst(dk);
                }
            } else {
                stack.addFirst(new DualKey(a2, b));
            }
        } else {
            stack.addFirst(new DualKey(a2, b));
        }
        return stack;
    }

    private static boolean isContainerType(Object o) {
        return o instanceof Collection || o instanceof Map;
    }

    private static boolean compareArrays(Object array1, Object array2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        int len = Array.getLength(array1);
        if (len != Array.getLength(array2)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            DualKey dk = new DualKey(path, Array.get(array1, i), Array.get(array2, i));
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K, V> boolean compareOrderedCollection(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        Iterator<V> i2 = col2.iterator();
        for (K k : col1) {
            DualKey dk = new DualKey(path, k, i2.next());
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K, V> boolean compareUnorderedCollection(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        HashMap<Integer, V> fastLookup = new HashMap<Integer, V>();
        for (Object o : col2) {
            fastLookup.put(DeepDifference.deepHashCode(o), o);
        }
        for (Object o : col1) {
            Object other = fastLookup.get(DeepDifference.deepHashCode(o));
            if (other == null) {
                return false;
            }
            DualKey dk = new DualKey(path, o, other);
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K1, V1, K2, V2> boolean compareSortedMap(SortedMap<K1, V1> map1, SortedMap<K2, V2> map2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry<K2, V2>> i2 = map2.entrySet().iterator();
        for (Map.Entry<K1, V1> entry1 : map1.entrySet()) {
            Map.Entry<K2, V2> entry2 = i2.next();
            DualKey dk = new DualKey(path, entry1.getKey(), entry2.getKey());
            if (!visited.contains(dk)) {
                toCompare.addFirst(dk);
            }
            if (visited.contains(dk = new DualKey(path, entry1.getValue(), entry2.getValue()))) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K1, V1, K2, V2> boolean compareUnorderedMap(Map<K1, V1> map1, Map<K2, V2> map2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        HashMap<Integer, Map.Entry<K2, V2>> fastLookup = new HashMap<Integer, Map.Entry<K2, V2>>();
        for (Map.Entry<K2, V2> entry : map2.entrySet()) {
            fastLookup.put(DeepDifference.deepHashCode(entry.getKey()), entry);
        }
        for (Map.Entry<Object, Object> entry : map1.entrySet()) {
            Map.Entry other = (Map.Entry)fastLookup.get(DeepDifference.deepHashCode(entry.getKey()));
            if (other == null) {
                return false;
            }
            DualKey dk = new DualKey(path, entry.getKey(), other.getKey());
            if (!visited.contains(dk)) {
                toCompare.addFirst(dk);
            }
            if (visited.contains(dk = new DualKey(path, entry.getValue(), other.getValue()))) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    static boolean hasCustomEquals(Class<?> c) {
        if (customEquals.containsKey(c)) {
            return customEquals.get(c);
        }
        Class<?> origClass = c;
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customEquals.put(origClass, false);
        return false;
    }

    static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (obj instanceof Double || obj instanceof Float) {
                stack.add(Math.round(((Number)obj).doubleValue()));
                continue;
            }
            if (DeepDifference.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Set<Field> fields = Objects.getDeclaredFieldsIncludingInherited(obj.getClass());
            for (Field field : fields) {
                stack.addFirst(PropertyOrFieldSupport.COMPARISON.getSimpleValue(field.getName(), obj));
            }
        }
        return hash;
    }

    static boolean hasCustomHashCode(Class<?> c) {
        Class<?> origClass = c;
        if (customHash.containsKey(c)) {
            return customHash.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customHash.put(origClass, false);
        return false;
    }

    public static class Difference {
        List<String> path;
        Object actual;
        Object other;

        public Difference(List<String> path, Object actual, Object other) {
            this.path = path;
            this.actual = actual;
            this.other = other;
        }

        public List<String> getPath() {
            return this.path;
        }

        public Object getActual() {
            return this.actual;
        }

        public Object getOther() {
            return this.other;
        }

        public String toString() {
            return "Difference [path=" + this.path + ", actual=" + this.actual + ", other=" + this.other + "]";
        }
    }

    private static final class DualKey {
        private final List<String> path;
        private final Object key1;
        private final Object key2;

        private DualKey(List<String> path, Object key1, Object key2) {
            this.path = path;
            this.key1 = key1;
            this.key2 = key2;
        }

        private DualKey(Object key1, Object key2) {
            this(new ArrayList<String>(), key1, key2);
        }

        public boolean equals(Object other) {
            if (!(other instanceof DualKey)) {
                return false;
            }
            DualKey that = (DualKey)other;
            return this.key1 == that.key1 && this.key2 == that.key2;
        }

        public int hashCode() {
            int h1 = this.key1 != null ? this.key1.hashCode() : 0;
            int h2 = this.key2 != null ? this.key2.hashCode() : 0;
            return h1 + h2;
        }

        public String toString() {
            return "DualKey [key1=" + this.key1 + ", key2=" + this.key2 + "]";
        }

        public List<String> getPath() {
            return this.path;
        }

        public String getConcatenatedPath() {
            return Strings.join(this.path).with(".");
        }
    }
}

