/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.Comparator;

public class FloatComparator
implements Comparator<Float> {
    private float epsilon;

    public FloatComparator(float epsilon) {
        this.epsilon = epsilon;
    }

    public float getEpsilon() {
        return this.epsilon;
    }

    @Override
    public int compare(Float x, Float y) {
        if (this.closeEnough(x, y, this.epsilon)) {
            return 0;
        }
        return x.floatValue() < y.floatValue() ? -1 : 1;
    }

    private boolean closeEnough(Float x, Float y, float epsilon) {
        return x == y || Math.abs(x.floatValue() - y.floatValue()) < epsilon;
    }

    private static boolean complexCloseEnough(float a2, float b, float epsilon) {
        float absA = Math.abs(a2);
        float absB = Math.abs(b);
        float diff = Math.abs(a2 - b);
        if (a2 == b) {
            return true;
        }
        if (a2 == 0.0f || b == 0.0f || diff < Float.MIN_NORMAL) {
            return diff < epsilon * Float.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Float.MAX_VALUE) < epsilon;
    }

    public int hashCode() {
        return 31 + Float.floatToIntBits(this.epsilon);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatComparator)) {
            return false;
        }
        FloatComparator other = (FloatComparator)obj;
        return Float.floatToIntBits(this.epsilon) == Float.floatToIntBits(other.epsilon);
    }
}

