/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.codepipelines;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.janusgraph.codepipelines.AwsCodePipelinesLogic;
import org.janusgraph.codepipelines.model.PipelineDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.ProfileCredentialsProvider;
import software.amazon.awssdk.client.builder.ClientHttpConfiguration;
import software.amazon.awssdk.http.apache.ApacheSdkHttpClientFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.CodeBuildClientBuilder;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineClientBuilder;
import software.amazon.awssdk.services.iam.model.IAMException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.BucketLocationConstraint;
import software.amazon.awssdk.services.s3.model.Tag;

public class AwsCodePipelinesCi {
    private static final Logger log = LoggerFactory.getLogger(AwsCodePipelinesCi.class);
    private static final Option REGION_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("region", "AWS region to create build stack");
    private static final Option BUCKET_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("bucket", "AWS S3 bucket to store artifacts");
    private static final Option CODEPIPELINE_ROLE_ARN_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("codepipeline-role-arn", "ARN of IAM role for CodePipeline to use");
    private static final Option GITHUB_OWNER_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("github-owner", "GitHub owner (organization) of the repository to build");
    private static final Option GITHUB_REPO_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("github-repo", "GitHub repository to build");
    private static final Option GITHUB_BRANCH_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("github-branch", "GitHub repository branch to build");
    private static final Option GITHUB_TOKEN_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("github-token", "GitHub personal access token for AWS CodeBuild to use to build");
    private static final Option PROFILE_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("profile", "AWS credential profile to use to create the stack");
    private static final Option PIPELINES_JSON_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("pipelines", "Path to JSON file containing abbreviated pipeline definitions");
    private static final Option CODE_BUILD_SERVICE_ROLE_ARN_OPTION = AwsCodePipelinesCi.createRequiredOneArgOption("codebuild-role-arn", "ARN of the service role for CodeBuild (https://docs.aws.amazon.com/codebuild/latest/userguide/setting-up.html#setting-up-service-role)");
    private static final Option CODE_BUILD_COMPUTE_IMAGE = AwsCodePipelinesCi.createOptionalOneArgOption("codebuild-compute-image", "Compute image to use for CodeBuild");
    private static final List<Option> OPTIONS = ImmutableList.of(REGION_OPTION, BUCKET_OPTION, CODEPIPELINE_ROLE_ARN_OPTION, GITHUB_OWNER_OPTION, GITHUB_REPO_OPTION, GITHUB_BRANCH_OPTION, GITHUB_TOKEN_OPTION, PROFILE_OPTION, PIPELINES_JSON_OPTION, CODE_BUILD_SERVICE_ROLE_ARN_OPTION, CODE_BUILD_COMPUTE_IMAGE);
    private static final boolean HAS_ARG = true;
    private static final String NULL_SHORT_OPT = null;
    private static final boolean REQUIRED_OPTION = true;
    private static final boolean NOT_REQUIRED_OPTION = false;
    private final CommandLine cmd;

    private void run() throws IOException {
        File file = new File(this.getOptionValue(PIPELINES_JSON_OPTION));
        Region region = Region.of(this.getOptionValue(REGION_OPTION));
        ProfileCredentialsProvider provider = ProfileCredentialsProvider.builder().profileName(this.getOptionValue(PROFILE_OPTION)).build();
        ClientHttpConfiguration http = ClientHttpConfiguration.builder().httpClient(((ApacheSdkHttpClientFactory)ApacheSdkHttpClientFactory.builder().socketTimeout(Duration.ofSeconds(10L)).connectionTimeout(Duration.ofMillis(750L)).build()).createHttpClient()).build();
        AwsCodePipelinesLogic.AwsCodePipelinesLogicBuilder builder = AwsCodePipelinesLogic.builder().githubToken(this.getOptionValue(GITHUB_TOKEN_OPTION)).githubOwner(this.getOptionValue(GITHUB_OWNER_OPTION)).githubRepo(this.getOptionValue(GITHUB_REPO_OPTION)).githubBranch(this.getOptionValue(GITHUB_BRANCH_OPTION)).codeBuildServiceRoleArn(this.getOptionValue(CODE_BUILD_SERVICE_ROLE_ARN_OPTION)).codePipelineRoleArn(this.getOptionValue(CODEPIPELINE_ROLE_ARN_OPTION)).s3Bucket(this.getOptionValue(BUCKET_OPTION)).s3BucketLocationConstraint(BucketLocationConstraint.fromValue(region.value())).s3((S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpConfiguration(http)).region(region)).credentialsProvider(provider)).build()).codeBuild((CodeBuildClient)((CodeBuildClientBuilder)((CodeBuildClientBuilder)((CodeBuildClientBuilder)CodeBuildClient.builder().httpConfiguration(http)).region(region)).credentialsProvider(provider)).build()).codePipeline((CodePipelineClient)((CodePipelineClientBuilder)((CodePipelineClientBuilder)((CodePipelineClientBuilder)CodePipelineClient.builder().httpConfiguration(http)).region(region)).credentialsProvider(provider)).build());
        Tag timeTag = (Tag)Tag.builder().key("date").value(Long.toString(System.currentTimeMillis())).build();
        PipelineDefinitions definitions = new ObjectMapper(new YAMLFactory()).readValue(file, PipelineDefinitions.class);
        definitions.getPipelines().stream().map(def -> builder.pipelineName(def.getName()).sourceOutputArtifactName(def.getName() + "Source").parallelBuildActions(def.getParallelBuildActions()).defaultComputeImage(definitions.getDefaultComputeImage()).defaultComputeType(definitions.getDefaultComputeType()).defaultPrivilegedMode(definitions.isDefaultPrivilegedMode()).tags(ImmutableList.of(Tag.builder().key("project").value(def.getName()).build(), timeTag)).build()).forEach(AwsCodePipelinesLogic::run);
    }

    public static void main(String[] args) {
        int status = 0;
        try {
            Options options = new Options();
            OPTIONS.forEach(options::addOption);
            new AwsCodePipelinesCi(new DefaultParser().parse(options, args)).run();
        }
        catch (IllegalArgumentException | ParseException e) {
            log.error(e.getMessage(), e);
            status = 22;
        }
        catch (IAMException e) {
            log.error(e.getMessage(), e);
            status = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            status = 11;
        }
        System.exit(status);
    }

    private String getOptionValue(Option option) {
        return this.cmd.getOptionValue(option.getLongOpt());
    }

    private static Option createRequiredOneArgOption(String longOpt, String description) {
        return AwsCodePipelinesCi.createOneArgOption(longOpt, description, true);
    }

    private static Option createOptionalOneArgOption(String longOpt, String description) {
        return AwsCodePipelinesCi.createOneArgOption(longOpt, description, false);
    }

    private static Option createOneArgOption(String longOpt, String description, boolean required) {
        Option o = new Option(NULL_SHORT_OPT, longOpt, true, description);
        o.setRequired(required);
        o.setArgs(1);
        return o;
    }

    @ConstructorProperties(value={"cmd"})
    public AwsCodePipelinesCi(CommandLine cmd) {
        this.cmd = cmd;
    }
}

