/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.codepipelines;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.janusgraph.codepipelines.model.ParallelBuildAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.model.ArtifactPackaging;
import software.amazon.awssdk.services.codebuild.model.ArtifactsType;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.Project;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.ActionDeclaration;
import software.amazon.awssdk.services.codepipeline.model.ActionOwner;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStore;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.InputArtifact;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifact;
import software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.BucketLocationConstraint;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;

class AwsCodePipelinesLogic {
    private static final Logger log = LoggerFactory.getLogger(AwsCodePipelinesLogic.class);
    private final S3Client s3;
    private final String s3Bucket;
    private final BucketLocationConstraint s3BucketLocationConstraint;
    private final String profileName;
    private final String pipelineName;
    private final String defaultComputeImage;
    private final ComputeType defaultComputeType;
    private final boolean defaultPrivilegedMode;
    private final String codeBuildServiceRoleArn;
    private final CodePipelineClient codePipeline;
    private final CodeBuildClient codeBuild;
    private final String codePipelineRoleArn;
    private final String githubToken;
    private final String githubOwner;
    private final String githubRepo;
    private final String githubBranch;
    private final String computeImage;
    private final List<ParallelBuildAction> parallelBuildActions;
    private final List<Tag> tags;
    private final String sourceOutputArtifactName;

    private ActionDeclaration createBuildActionDeclaration(Project project, int version) {
        return (ActionDeclaration)ActionDeclaration.builder().name(project.name()).inputArtifacts((InputArtifact)InputArtifact.builder().name(this.sourceOutputArtifactName).build()).actionTypeId((ActionTypeId)ActionTypeId.builder().category(ActionCategory.Build).owner(ActionOwner.AWS).provider("CodeBuild").version(Integer.toString(version)).build()).outputArtifacts((OutputArtifact)OutputArtifact.builder().name(project.artifacts().name()).build()).configuration(ImmutableMap.of("ProjectName", project.name())).runOrder(1).build();
    }

    private StageDeclaration createBuildStageDeclaration(List<Project> createdProjects, int version) {
        return (StageDeclaration)StageDeclaration.builder().name("Build").actions(createdProjects.stream().map(action -> this.createBuildActionDeclaration((Project)action, version)).collect(Collectors.toList())).build();
    }

    private StageDeclaration createSourceStageDeclaration(int version) {
        Preconditions.checkArgument(version > 0);
        return (StageDeclaration)StageDeclaration.builder().name("Source").actions((ActionDeclaration)ActionDeclaration.builder().name(this.pipelineName).actionTypeId((ActionTypeId)ActionTypeId.builder().category(ActionCategory.Source).owner(ActionOwner.ThirdParty).provider("GitHub").version(Integer.toString(version)).build()).outputArtifacts((OutputArtifact)OutputArtifact.builder().name(this.sourceOutputArtifactName).build()).configuration(ImmutableMap.of("Owner", this.githubOwner, "Repo", this.githubRepo, "Branch", this.githubBranch, "OAuthToken", this.githubToken)).runOrder(1).build()).build();
    }

    private CreateProjectRequest createCodeBuildProjectRequest(ParallelBuildAction action) {
        log.info("Creating CodeBuild project for " + action.getName());
        Preconditions.checkArgument(action.getTimeout() <= 480 && action.getTimeout() > 0, "timeoutInMinutes must be greater than zero and less than or equal to 8 hours");
        return (CreateProjectRequest)CreateProjectRequest.builder().name(this.pipelineName + "-" + action.getName()).serviceRole(this.codeBuildServiceRoleArn).artifacts((ProjectArtifacts)ProjectArtifacts.builder().packaging(ArtifactPackaging.NONE).type(ArtifactsType.CODEPIPELINE).name(action.getName() + "-artifacts").build()).timeoutInMinutes(action.getTimeout()).environment((ProjectEnvironment)ProjectEnvironment.builder().computeType(action.getComputeType().orElse(this.defaultComputeType)).image(action.getComputeImage().orElse(this.defaultComputeImage)).type(EnvironmentType.LINUX_CONTAINER).privilegedMode(action.getPrivilegedMode().orElse(this.defaultPrivilegedMode)).environmentVariables(action.getEnv().stream().map(e -> (EnvironmentVariable)EnvironmentVariable.builder().name(e.getName()).value(e.getValue()).build()).collect(Collectors.toList())).build()).source((ProjectSource)ProjectSource.builder().type(SourceType.CODEPIPELINE).build()).build();
    }

    void run() {
        this.assureS3Bucket();
        List<Project> buildProjects = this.createBuildProjects();
        boolean version = true;
        StageDeclaration sourceStage = this.createSourceStageDeclaration(1);
        StageDeclaration buildStage = this.createBuildStageDeclaration(buildProjects, 1);
        CreatePipelineResponse pipeline = this.codePipeline.createPipeline((CreatePipelineRequest)CreatePipelineRequest.builder().pipeline((PipelineDeclaration)PipelineDeclaration.builder().roleArn(this.codePipelineRoleArn).name(this.pipelineName).version(Integer.MAX_VALUE).stages(sourceStage, buildStage).artifactStore((ArtifactStore)ArtifactStore.builder().type(ArtifactStoreType.S3).location(this.s3Bucket).build()).build()).build());
        Preconditions.checkNotNull(pipeline, "created pipeline was null");
    }

    private void assureS3Bucket() {
        try {
            this.s3.createBucket((CreateBucketRequest)CreateBucketRequest.builder().createBucketConfiguration((CreateBucketConfiguration)CreateBucketConfiguration.builder().locationConstraint(this.s3BucketLocationConstraint).build()).bucket(this.s3Bucket).build());
            this.s3.putBucketTagging((PutBucketTaggingRequest)PutBucketTaggingRequest.builder().bucket(this.s3Bucket).tagging((Tagging)Tagging.builder().tagSet(this.tags).build()).build());
            log.info("Created bucket " + this.s3Bucket);
        }
        catch (S3Exception e) {
            if (e.getErrorCode().equals("BucketAlreadyOwnedByYou")) {
                log.info("Bucket " + this.s3Bucket + " in region already owned by you");
            }
            throw new IllegalArgumentException("Unable to create/configure bucket", e);
        }
    }

    private List<Project> createBuildProjects() {
        return this.parallelBuildActions.stream().map(this::createCodeBuildProjectRequest).peek(project -> log.info(project.toString())).map(this.codeBuild::createProject).map(CreateProjectResponse::project).collect(Collectors.toList());
    }

    public static AwsCodePipelinesLogicBuilder builder() {
        return new AwsCodePipelinesLogicBuilder();
    }

    @ConstructorProperties(value={"s3", "s3Bucket", "s3BucketLocationConstraint", "profileName", "pipelineName", "defaultComputeImage", "defaultComputeType", "defaultPrivilegedMode", "codeBuildServiceRoleArn", "codePipeline", "codeBuild", "codePipelineRoleArn", "githubToken", "githubOwner", "githubRepo", "githubBranch", "computeImage", "parallelBuildActions", "tags", "sourceOutputArtifactName"})
    public AwsCodePipelinesLogic(S3Client s3, String s3Bucket, BucketLocationConstraint s3BucketLocationConstraint, String profileName, String pipelineName, String defaultComputeImage, ComputeType defaultComputeType, boolean defaultPrivilegedMode, String codeBuildServiceRoleArn, CodePipelineClient codePipeline, CodeBuildClient codeBuild, String codePipelineRoleArn, String githubToken, String githubOwner, String githubRepo, String githubBranch, String computeImage, List<ParallelBuildAction> parallelBuildActions, List<Tag> tags, String sourceOutputArtifactName) {
        this.s3 = s3;
        this.s3Bucket = s3Bucket;
        this.s3BucketLocationConstraint = s3BucketLocationConstraint;
        this.profileName = profileName;
        this.pipelineName = pipelineName;
        this.defaultComputeImage = defaultComputeImage;
        this.defaultComputeType = defaultComputeType;
        this.defaultPrivilegedMode = defaultPrivilegedMode;
        this.codeBuildServiceRoleArn = codeBuildServiceRoleArn;
        this.codePipeline = codePipeline;
        this.codeBuild = codeBuild;
        this.codePipelineRoleArn = codePipelineRoleArn;
        this.githubToken = githubToken;
        this.githubOwner = githubOwner;
        this.githubRepo = githubRepo;
        this.githubBranch = githubBranch;
        this.computeImage = computeImage;
        this.parallelBuildActions = parallelBuildActions;
        this.tags = tags;
        this.sourceOutputArtifactName = sourceOutputArtifactName;
    }

    public String toString() {
        return "AwsCodePipelinesLogic(s3=" + this.s3 + ", s3Bucket=" + this.s3Bucket + ", s3BucketLocationConstraint=" + (Object)((Object)this.s3BucketLocationConstraint) + ", profileName=" + this.profileName + ", pipelineName=" + this.pipelineName + ", defaultComputeImage=" + this.defaultComputeImage + ", defaultComputeType=" + (Object)((Object)this.defaultComputeType) + ", defaultPrivilegedMode=" + this.defaultPrivilegedMode + ", codeBuildServiceRoleArn=" + this.codeBuildServiceRoleArn + ", codePipeline=" + this.codePipeline + ", codeBuild=" + this.codeBuild + ", codePipelineRoleArn=" + this.codePipelineRoleArn + ", githubToken=" + this.githubToken + ", githubOwner=" + this.githubOwner + ", githubRepo=" + this.githubRepo + ", githubBranch=" + this.githubBranch + ", computeImage=" + this.computeImage + ", parallelBuildActions=" + this.parallelBuildActions + ", tags=" + this.tags + ", sourceOutputArtifactName=" + this.sourceOutputArtifactName + ")";
    }

    public static class AwsCodePipelinesLogicBuilder {
        private S3Client s3;
        private String s3Bucket;
        private BucketLocationConstraint s3BucketLocationConstraint;
        private String profileName;
        private String pipelineName;
        private String defaultComputeImage;
        private ComputeType defaultComputeType;
        private boolean defaultPrivilegedMode;
        private String codeBuildServiceRoleArn;
        private CodePipelineClient codePipeline;
        private CodeBuildClient codeBuild;
        private String codePipelineRoleArn;
        private String githubToken;
        private String githubOwner;
        private String githubRepo;
        private String githubBranch;
        private String computeImage;
        private List<ParallelBuildAction> parallelBuildActions;
        private List<Tag> tags;
        private String sourceOutputArtifactName;

        AwsCodePipelinesLogicBuilder() {
        }

        public AwsCodePipelinesLogicBuilder s3(S3Client s3) {
            this.s3 = s3;
            return this;
        }

        public AwsCodePipelinesLogicBuilder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public AwsCodePipelinesLogicBuilder s3BucketLocationConstraint(BucketLocationConstraint s3BucketLocationConstraint) {
            this.s3BucketLocationConstraint = s3BucketLocationConstraint;
            return this;
        }

        public AwsCodePipelinesLogicBuilder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public AwsCodePipelinesLogicBuilder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public AwsCodePipelinesLogicBuilder defaultComputeImage(String defaultComputeImage) {
            this.defaultComputeImage = defaultComputeImage;
            return this;
        }

        public AwsCodePipelinesLogicBuilder defaultComputeType(ComputeType defaultComputeType) {
            this.defaultComputeType = defaultComputeType;
            return this;
        }

        public AwsCodePipelinesLogicBuilder defaultPrivilegedMode(boolean defaultPrivilegedMode) {
            this.defaultPrivilegedMode = defaultPrivilegedMode;
            return this;
        }

        public AwsCodePipelinesLogicBuilder codeBuildServiceRoleArn(String codeBuildServiceRoleArn) {
            this.codeBuildServiceRoleArn = codeBuildServiceRoleArn;
            return this;
        }

        public AwsCodePipelinesLogicBuilder codePipeline(CodePipelineClient codePipeline) {
            this.codePipeline = codePipeline;
            return this;
        }

        public AwsCodePipelinesLogicBuilder codeBuild(CodeBuildClient codeBuild) {
            this.codeBuild = codeBuild;
            return this;
        }

        public AwsCodePipelinesLogicBuilder codePipelineRoleArn(String codePipelineRoleArn) {
            this.codePipelineRoleArn = codePipelineRoleArn;
            return this;
        }

        public AwsCodePipelinesLogicBuilder githubToken(String githubToken) {
            this.githubToken = githubToken;
            return this;
        }

        public AwsCodePipelinesLogicBuilder githubOwner(String githubOwner) {
            this.githubOwner = githubOwner;
            return this;
        }

        public AwsCodePipelinesLogicBuilder githubRepo(String githubRepo) {
            this.githubRepo = githubRepo;
            return this;
        }

        public AwsCodePipelinesLogicBuilder githubBranch(String githubBranch) {
            this.githubBranch = githubBranch;
            return this;
        }

        public AwsCodePipelinesLogicBuilder computeImage(String computeImage) {
            this.computeImage = computeImage;
            return this;
        }

        public AwsCodePipelinesLogicBuilder parallelBuildActions(List<ParallelBuildAction> parallelBuildActions) {
            this.parallelBuildActions = parallelBuildActions;
            return this;
        }

        public AwsCodePipelinesLogicBuilder tags(List<Tag> tags) {
            this.tags = tags;
            return this;
        }

        public AwsCodePipelinesLogicBuilder sourceOutputArtifactName(String sourceOutputArtifactName) {
            this.sourceOutputArtifactName = sourceOutputArtifactName;
            return this;
        }

        public AwsCodePipelinesLogic build() {
            return new AwsCodePipelinesLogic(this.s3, this.s3Bucket, this.s3BucketLocationConstraint, this.profileName, this.pipelineName, this.defaultComputeImage, this.defaultComputeType, this.defaultPrivilegedMode, this.codeBuildServiceRoleArn, this.codePipeline, this.codeBuild, this.codePipelineRoleArn, this.githubToken, this.githubOwner, this.githubRepo, this.githubBranch, this.computeImage, this.parallelBuildActions, this.tags, this.sourceOutputArtifactName);
        }

        public String toString() {
            return "AwsCodePipelinesLogic.AwsCodePipelinesLogicBuilder(s3=" + this.s3 + ", s3Bucket=" + this.s3Bucket + ", s3BucketLocationConstraint=" + (Object)((Object)this.s3BucketLocationConstraint) + ", profileName=" + this.profileName + ", pipelineName=" + this.pipelineName + ", defaultComputeImage=" + this.defaultComputeImage + ", defaultComputeType=" + (Object)((Object)this.defaultComputeType) + ", defaultPrivilegedMode=" + this.defaultPrivilegedMode + ", codeBuildServiceRoleArn=" + this.codeBuildServiceRoleArn + ", codePipeline=" + this.codePipeline + ", codeBuild=" + this.codeBuild + ", codePipelineRoleArn=" + this.codePipelineRoleArn + ", githubToken=" + this.githubToken + ", githubOwner=" + this.githubOwner + ", githubRepo=" + this.githubRepo + ", githubBranch=" + this.githubBranch + ", computeImage=" + this.computeImage + ", parallelBuildActions=" + this.parallelBuildActions + ", tags=" + this.tags + ", sourceOutputArtifactName=" + this.sourceOutputArtifactName + ")";
        }
    }
}

