/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.codepipelines.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import org.janusgraph.codepipelines.model.EnvironmentMapping;
import software.amazon.awssdk.services.codebuild.model.ComputeType;

public final class ParallelBuildAction {
    private final String name;
    private final Optional<ComputeType> computeType;
    private final Optional<String> computeImage;
    private final Optional<Boolean> privilegedMode;
    private final int timeout;
    private final List<EnvironmentMapping> env;

    @JsonCreator
    public ParallelBuildAction(@JsonProperty(value="name") String name, @JsonProperty(value="computeType") String computeType, @JsonProperty(value="computeImage") String computeImage, @JsonProperty(value="privilegedMode") Boolean privilegedMode, @JsonProperty(value="env") List<EnvironmentMapping> env, @JsonProperty(value="timeout") int timeout) {
        this.name = name;
        this.computeType = Strings.isNullOrEmpty(computeType) ? Optional.empty() : Optional.of(ComputeType.fromValue(computeType));
        this.computeImage = Strings.isNullOrEmpty(computeImage) ? Optional.empty() : Optional.of(computeImage);
        this.privilegedMode = privilegedMode == null ? Optional.empty() : Optional.of(privilegedMode);
        this.timeout = timeout;
        this.env = env;
    }

    public String getName() {
        return this.name;
    }

    public Optional<ComputeType> getComputeType() {
        return this.computeType;
    }

    public Optional<String> getComputeImage() {
        return this.computeImage;
    }

    public Optional<Boolean> getPrivilegedMode() {
        return this.privilegedMode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List<EnvironmentMapping> getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParallelBuildAction)) {
            return false;
        }
        ParallelBuildAction other = (ParallelBuildAction)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<ComputeType> this$computeType = this.getComputeType();
        Optional<ComputeType> other$computeType = other.getComputeType();
        if (this$computeType == null ? other$computeType != null : !((Object)this$computeType).equals(other$computeType)) {
            return false;
        }
        Optional<String> this$computeImage = this.getComputeImage();
        Optional<String> other$computeImage = other.getComputeImage();
        if (this$computeImage == null ? other$computeImage != null : !((Object)this$computeImage).equals(other$computeImage)) {
            return false;
        }
        Optional<Boolean> this$privilegedMode = this.getPrivilegedMode();
        Optional<Boolean> other$privilegedMode = other.getPrivilegedMode();
        if (this$privilegedMode == null ? other$privilegedMode != null : !((Object)this$privilegedMode).equals(other$privilegedMode)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        List<EnvironmentMapping> this$env = this.getEnv();
        List<EnvironmentMapping> other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !((Object)this$env).equals(other$env));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<ComputeType> $computeType = this.getComputeType();
        result = result * 59 + ($computeType == null ? 43 : ((Object)$computeType).hashCode());
        Optional<String> $computeImage = this.getComputeImage();
        result = result * 59 + ($computeImage == null ? 43 : ((Object)$computeImage).hashCode());
        Optional<Boolean> $privilegedMode = this.getPrivilegedMode();
        result = result * 59 + ($privilegedMode == null ? 43 : ((Object)$privilegedMode).hashCode());
        result = result * 59 + this.getTimeout();
        List<EnvironmentMapping> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        return result;
    }

    public String toString() {
        return "ParallelBuildAction(name=" + this.getName() + ", computeType=" + this.getComputeType() + ", computeImage=" + this.getComputeImage() + ", privilegedMode=" + this.getPrivilegedMode() + ", timeout=" + this.getTimeout() + ", env=" + this.getEnv() + ")";
    }
}

