/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.ServiceNameFactory;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.auth.RegionAwareSigner;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.SignerFactory;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.ExecutionContext;
import software.amazon.awssdk.internal.auth.DefaultSignerProvider;
import software.amazon.awssdk.log.CommonsLogFactory;
import software.amazon.awssdk.log.InternalLogFactory;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.runtime.auth.SignerProviderContext;
import software.amazon.awssdk.runtime.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.util.AwsHostNameUtils;
import software.amazon.awssdk.util.Classes;
import software.amazon.awssdk.util.RuntimeHttpUtils;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

public abstract class AmazonWebServiceClient {
    @Deprecated
    public static final boolean LOGGING_AWS_REQUEST_METRIC = true;
    private static final String AMAZON = "Amazon";
    private static final String AWS = "AWS";
    private static final Log LOG = LogFactory.getLog(AmazonWebServiceClient.class);
    protected final List<RequestHandler> requestHandlers;
    protected volatile URI endpoint;
    protected LegacyClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected int timeOffset;
    private volatile boolean isImmutable = false;
    private volatile String signerRegionOverride;
    private volatile SignerProvider signerProvider;
    private volatile String serviceName;
    private volatile String endpointPrefix;

    public AmazonWebServiceClient(LegacyClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(LegacyClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this(clientConfiguration, requestMetricCollector, false);
    }

    @SdkProtectedApi
    protected AmazonWebServiceClient(LegacyClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector, boolean disableStrictHostNameVerification) {
        this.clientConfiguration = clientConfiguration;
        this.requestHandlers = new CopyOnWriteArrayList<RequestHandler>();
        this.client = AmazonHttpClient.builder().clientConfiguration(clientConfiguration).requestMetricCollector(requestMetricCollector).calculateCrc32FromCompressedData(this.calculateCrc32FromCompressedData()).build();
    }

    protected AmazonWebServiceClient(AwsSyncClientParams clientParams) {
        this.clientConfiguration = clientParams.getClientConfiguration();
        this.requestHandlers = clientParams.getRequestHandlers();
        this.client = AmazonHttpClient.builder().sdkHttpClient(clientParams.sdkHttpClient()).clientConfiguration(this.clientConfiguration).requestMetricCollector(clientParams.getRequestMetricCollector()).calculateCrc32FromCompressedData(this.calculateCrc32FromCompressedData()).build();
    }

    @Deprecated
    protected Signer getSigner() {
        return this.signerProvider.getSigner(SignerProviderContext.builder().build());
    }

    @SdkProtectedApi
    protected SignerProvider getSignerProvider() {
        return this.signerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.checkMutability();
        URI uri = this.toUri(endpoint);
        Signer signer = this.computeSignerByUri(uri, this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uri;
            this.signerProvider = this.createSignerProvider(signer);
        }
    }

    private URI toUri(String endpoint) throws IllegalArgumentException {
        return RuntimeHttpUtils.toUri(endpoint, this.clientConfiguration);
    }

    public Signer getSignerByUri(URI uri) {
        return this.computeSignerByUri(uri, this.signerRegionOverride, true);
    }

    private Signer computeSignerByUri(URI uri, String signerRegionOverride, boolean isRegionIdAsSignerParam) {
        if (uri == null) {
            throw new IllegalArgumentException("Endpoint is not set. Use setEndpoint to set an endpoint before performing any request.");
        }
        String service = this.getServiceNameIntern();
        String region = AwsHostNameUtils.parseRegionName(uri.getHost(), service);
        return this.computeSignerByServiceRegion(service, region, signerRegionOverride, isRegionIdAsSignerParam);
    }

    private Signer computeSignerByServiceRegion(String serviceName, String regionId, String signerRegionOverride, boolean isRegionIdAsSignerParam) {
        Signer signer;
        String signerType = this.clientConfiguration.getSignerOverride();
        Signer signer2 = signer = signerType == null ? SignerFactory.getSigner(serviceName, regionId) : SignerFactory.getSignerByTypeAndService(signerType, serviceName);
        if (signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionAwareSigner = (RegionAwareSigner)signer;
            if (signerRegionOverride != null) {
                regionAwareSigner.setRegionName(signerRegionOverride);
            } else if (regionId != null && isRegionIdAsSignerParam) {
                regionAwareSigner.setRegionName(regionId);
            }
        }
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setRegion(Region region) throws IllegalArgumentException {
        this.checkMutability();
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        String serviceNameForEndpoint = this.getEndpointPrefix();
        String serviceNameForSigner = this.getServiceNameIntern();
        String protocol = this.clientConfiguration.getProtocol().toString();
        URI uri = new DefaultServiceEndpointBuilder(serviceNameForEndpoint, protocol).withRegion(region).getServiceEndpoint();
        Signer signer = this.computeSignerByServiceRegion(serviceNameForSigner, region.value(), this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uri;
            this.signerProvider = this.createSignerProvider(signer);
        }
    }

    public void shutdown() {
        FunctionalUtils.invokeSafely(this.client::close);
    }

    protected final <T extends AmazonWebServiceRequest> T beforeMarshalling(T request) {
        Object local = request;
        for (RequestHandler handler : this.requestHandlers) {
            local = handler.beforeMarshalling((AmazonWebServiceRequest)local);
        }
        return local;
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest req) {
        return this.createExecutionContext(req, this.signerProvider);
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest req, SignerProvider signerProvider) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(req);
        return ExecutionContext.builder().withRequestHandlers(this.requestHandlers).withUseRequestMetrics(isMetricsEnabled).withAwsClient(this).withSignerProvider(signerProvider).build();
    }

    protected final ExecutionContext createExecutionContext(Request<?> req) {
        return this.createExecutionContext(req.getOriginalRequest());
    }

    protected SignerProvider createSignerProvider(Signer signer) {
        return new DefaultSignerProvider(signer);
    }

    protected final boolean isRequestMetricsEnabled(AmazonWebServiceRequest req) {
        RequestMetricCollector c = req.getRequestMetricCollector();
        if (c != null && c.isEnabled()) {
            return true;
        }
        return this.isRmcEnabledAtClientOrSdkLevel();
    }

    private boolean isRmcEnabledAtClientOrSdkLevel() {
        RequestMetricCollector c = this.requestMetricCollector();
        return c != null && c.isEnabled();
    }

    public AmazonWebServiceClient withTimeOffset(int timeOffset) {
        this.checkMutability();
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(int timeOffset) {
        this.checkMutability();
        this.timeOffset = timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector mc = this.client.getRequestMetricCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    private final RequestMetricCollector findRequestMetricCollector(RequestMetricCollector reqLevelMetricsCollector) {
        if (reqLevelMetricsCollector != null) {
            return reqLevelMetricsCollector;
        }
        if (this.getRequestMetricsCollector() != null) {
            return this.getRequestMetricsCollector();
        }
        return AwsSdkMetrics.getRequestMetricCollector();
    }

    protected final void endClientExecution(AwsRequestMetrics awsRequestMetrics, Request<?> request) {
        this.endClientExecution(awsRequestMetrics, request, null, false);
    }

    protected final void endClientExecution(AwsRequestMetrics awsRequestMetrics, Request<?> request, Response<?> response, @Deprecated boolean loggingAwsRequestMetrics) {
        if (request != null) {
            awsRequestMetrics.endEvent(AwsRequestMetrics.Field.ClientExecuteTime);
            awsRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector c = this.findRequestMetricCollector(request.getOriginalRequest().getRequestMetricCollector());
            c.collectMetrics(request, response.getAwsResponse());
            awsRequestMetrics.log();
        }
    }

    @Deprecated
    protected String getServiceAbbreviation() {
        return this.getServiceNameIntern();
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndpointPrefix() {
        if (this.endpointPrefix != null) {
            return this.endpointPrefix;
        }
        String httpClientName = this.getHttpClientName();
        String serviceNameInRegionMetadata = ServiceNameFactory.getServiceNameInRegionMetadata(httpClientName);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            if (this.endpointPrefix == null) {
                this.endpointPrefix = serviceNameInRegionMetadata != null ? serviceNameInRegionMetadata : this.getServiceNameIntern();
            }
            return this.endpointPrefix;
        }
    }

    protected void setEndpointPrefix(String endpointPrefix) {
        if (endpointPrefix == null) {
            throw new IllegalArgumentException("The parameter endpointPrefix must be specified!");
        }
        this.endpointPrefix = endpointPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceNameIntern() {
        if (this.serviceName == null) {
            AmazonWebServiceClient amazonWebServiceClient = this;
            synchronized (amazonWebServiceClient) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceName();
                }
            }
        }
        return this.serviceName;
    }

    public final void setServiceNameIntern(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("The parameter serviceName must be specified!");
        }
        this.serviceName = serviceName;
    }

    private String computeServiceName() {
        int len;
        String httpClientName = this.getHttpClientName();
        String service = ServiceNameFactory.getServiceName(httpClientName);
        if (service != null) {
            return service;
        }
        int j = httpClientName.indexOf("JavaClient");
        if (j == -1 && (j = httpClientName.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the AWS http client class name " + httpClientName);
        }
        int i = httpClientName.indexOf(AMAZON);
        if (i == -1) {
            i = httpClientName.indexOf(AWS);
            if (i == -1) {
                throw new IllegalStateException("Unrecognized prefix for the AWS http client class name " + httpClientName);
            }
            len = AWS.length();
        } else {
            len = AMAZON.length();
        }
        if (i >= j) {
            throw new IllegalStateException("Unrecognized AWS http client class name " + httpClientName);
        }
        String serviceName = httpClientName.substring(i + len, j);
        return StringUtils.lowerCase(serviceName);
    }

    private String getHttpClientName() {
        Class<?> httpClientClass = Classes.childClassOf(AmazonWebServiceClient.class, this);
        return httpClientClass.getSimpleName();
    }

    public final String getSignerRegionOverride() {
        return this.signerRegionOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSignerRegionOverride(String signerRegionOverride) {
        this.checkMutability();
        Signer signer = this.computeSignerByUri(this.endpoint, signerRegionOverride, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signerRegionOverride = signerRegionOverride;
            this.signerProvider = this.createSignerProvider(signer);
        }
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withRegion(Region region) {
        this.setRegion(region);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    @Deprecated
    @SdkInternalApi
    public final void makeImmutable() {
        this.isImmutable = true;
    }

    @SdkProtectedApi
    protected final void checkMutability() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Client is immutable when created with the builder.");
        }
    }

    protected boolean useStrictHostNameVerification() {
        return true;
    }

    protected boolean calculateCrc32FromCompressedData() {
        return false;
    }

    static {
        boolean success = InternalLogFactory.configureFactory(new CommonsLogFactory());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Internal logging successfully configured to commons logger: " + success);
        }
    }
}

