/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.auth.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.MetricsReportingCredentialsProvider;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.ExecutionContext;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTrackerTask;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.utils.Validate;

public final class RequestExecutionContext {
    private final SdkHttpRequestProvider requestProvider;
    private final RequestConfig requestConfig;
    private final AwsRequestMetrics awsRequestMetrics;
    private final AwsCredentialsProvider credentialsProvider;
    private final List<RequestHandler> requestHandlers;
    private final SignerProvider signerProvider;
    private ClientExecutionAbortTrackerTask clientExecutionTrackerTask;

    private RequestExecutionContext(Builder builder) {
        this.requestProvider = builder.requestProvider;
        this.requestConfig = Validate.notNull(builder.requestConfig, "RequestConfig must not be null", new Object[0]);
        this.requestHandlers = builder.resolveRequestHandlers();
        this.awsRequestMetrics = builder.executionContext.getAwsRequestMetrics();
        this.signerProvider = builder.executionContext.getSignerProvider();
        AwsCredentialsProvider contextCredentialsProvider = builder.executionContext.getCredentialsProvider();
        this.credentialsProvider = contextCredentialsProvider != null ? new MetricsReportingCredentialsProvider(contextCredentialsProvider, this.awsRequestMetrics) : new AnonymousCredentialsProvider();
    }

    public static Builder builder() {
        return new Builder();
    }

    public SdkHttpRequestProvider requestProvider() {
        return this.requestProvider;
    }

    public RequestConfig requestConfig() {
        return this.requestConfig;
    }

    public List<RequestHandler> requestHandlers() {
        return Collections.unmodifiableList(this.requestHandlers);
    }

    public AwsRequestMetrics awsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    public AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    public SignerProvider signerProvider() {
        return this.signerProvider;
    }

    public ClientExecutionAbortTrackerTask getClientExecutionTrackerTask() {
        return this.clientExecutionTrackerTask;
    }

    public void setClientExecutionTrackerTask(ClientExecutionAbortTrackerTask clientExecutionTrackerTask) {
        this.clientExecutionTrackerTask = clientExecutionTrackerTask;
    }

    public static final class Builder {
        private SdkHttpRequestProvider requestProvider;
        private RequestConfig requestConfig;
        private ExecutionContext executionContext;

        public Builder requestProvider(SdkHttpRequestProvider requestProvider) {
            this.requestProvider = requestProvider;
            return this;
        }

        public Builder requestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        public Builder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        private List<RequestHandler> resolveRequestHandlers() {
            Validate.notNull(this.executionContext, "Execution context must be initialized before resolving request handlers.", new Object[0]);
            List<RequestHandler> requestHandlers = this.executionContext.getRequestHandlers();
            if (requestHandlers == null) {
                return Collections.emptyList();
            }
            return requestHandlers;
        }

        public RequestExecutionContext build() {
            Validate.notNull(this.executionContext, "executionContext must not be null", new Object[0]);
            return new RequestExecutionContext(this);
        }
    }
}

