/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.async;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.async.AsyncResponseHandler;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
class FileAsyncResponseHandler<ResponseT>
implements AsyncResponseHandler<ResponseT, Void> {
    private final Path path;
    private AsynchronousFileChannel fileChannel;

    FileAsyncResponseHandler(Path path) {
        this.path = path;
    }

    private AsynchronousFileChannel createChannel(Path path) throws IOException {
        return AsynchronousFileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
    }

    @Override
    public void responseReceived(ResponseT response) {
    }

    @Override
    public void onStream(Publisher<ByteBuffer> publisher) {
        this.fileChannel = FunctionalUtils.invokeSafely(() -> this.createChannel(this.path));
        publisher.subscribe(new FileSubscriber());
    }

    @Override
    public void exceptionOccurred(Throwable throwable) {
        try {
            FunctionalUtils.invokeSafely(this.fileChannel::close);
        }
        catch (RuntimeException e) {
            this.path.toFile().delete();
            throw e;
        }
        if (!this.path.toFile().delete()) {
            throw new UncheckedIOException(new IOException(String.format("Could not delete %s.", this.path.toFile().getAbsolutePath())));
        }
    }

    @Override
    public Void complete() {
        FunctionalUtils.invokeSafely(this.fileChannel::close);
        return null;
    }

    private class FileSubscriber
    implements Subscriber<ByteBuffer> {
        private final AtomicLong position = new AtomicLong();
        private Subscription subscription;

        private FileSubscriber() {
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.subscription = s;
            s.request(1L);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            FileAsyncResponseHandler.this.fileChannel.write(byteBuffer, this.position.get(), byteBuffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    if (result > 0) {
                        FileSubscriber.this.position.addAndGet(result.intValue());
                        FileSubscriber.this.subscription.request(1L);
                    }
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    FileSubscriber.this.subscription.cancel();
                }
            });
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onComplete() {
        }
    }
}

