/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.AwsSystemSetting;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.ContainerCredentialsRetryPolicy;
import software.amazon.awssdk.auth.EC2CredentialsProvider;
import software.amazon.awssdk.internal.CredentialsEndpointProvider;
import software.amazon.awssdk.retry.internal.CredentialsEndpointRetryPolicy;
import software.amazon.awssdk.utils.Logger;

public class ElasticContainerCredentialsProvider
implements AwsCredentialsProvider,
AutoCloseable {
    private static final Logger LOG = Logger.loggerFor(ElasticContainerCredentialsProvider.class);
    private final EC2CredentialsProvider credentialsFetcher;

    public ElasticContainerCredentialsProvider() {
        this(ElasticContainerCredentialsProvider.builder());
    }

    private ElasticContainerCredentialsProvider(Builder builder) {
        this.credentialsFetcher = new EC2CredentialsProvider(builder.credentialsEndpointProvider, builder.asyncCredentialUpdateEnabled, "elastic-container-credentials-provider");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AwsCredentials getCredentials() {
        if (!ElasticContainerCredentialsProvider.isEnabled()) {
            throw new SdkClientException(String.format("Credentials cannot be loaded from ECS because the ECS credentials environment variable (%s) and system property (%s) are not set or cannot be accessed due to the security manager.", AwsSystemSetting.AWS_CONTAINER_SERVICE_ENDPOINT.environmentVariable(), AwsSystemSetting.AWS_CONTAINER_SERVICE_ENDPOINT.property()));
        }
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void close() {
        this.credentialsFetcher.close();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static boolean isEnabled() {
        return AwsSystemSetting.AWS_CONTAINER_CREDENTIALS_PATH.getStringValue().isPresent();
    }

    public static final class Builder {
        private Boolean asyncCredentialUpdateEnabled = false;
        private CredentialsEndpointProvider credentialsEndpointProvider = new EcsCredentialsEndpointProvider();

        private Builder() {
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        @SdkTestInternalApi
        Builder credentialsEndpointProvider(CredentialsEndpointProvider credentialsEndpointProvider) {
            this.credentialsEndpointProvider = credentialsEndpointProvider;
            return this;
        }

        public ElasticContainerCredentialsProvider build() {
            return new ElasticContainerCredentialsProvider(this);
        }
    }

    private static class EcsCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        private EcsCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() throws URISyntaxException {
            return new URI(AwsSystemSetting.AWS_CONTAINER_SERVICE_ENDPOINT.getStringValueOrThrow() + AwsSystemSetting.AWS_CONTAINER_CREDENTIALS_PATH.getStringValueOrThrow());
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return new ContainerCredentialsRetryPolicy();
        }
    }
}

